#pragma once
#include "FilterBase.h"
#include "FilterFactoryBase.h"
#include "Settings.h"
#include "SyncObject.h"
#include "ILogManager.h"
#include "TextTools.h"

class CAccessLogFilter :
	public CFilterBase
{
public:
	CAccessLogFilter(void);
	virtual ~CAccessLogFilter(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory(eĂ΂)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void _FilterFactoryStart(CIServerToolWrap serverTool);

	//!	~
	virtual void FilterFactoryStop();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilter
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	virtual LPCTSTR GetFilterName();

	//!	ؒf(OցI)
	virtual void _FilterStop(CIConnectionToolWrap filterContext);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Oo
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	`FbN
	int IsIgnore(CString serverPath);

	//!	O擾
	CString	GetLogFilePath(CContext &context);

	//!	O擾
	CString	GetLog(CContext &context);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection			m_scopeLock;

	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	CIServerToolWrap			m_serverTool;

	//!	ݒ
	CAccessLogFilterSetting		m_setting;

	//!	O}l[W
	CILogManagerWrap			m_logManager;

	//!	t@CpX
	CLockObject<CString>		m_logFilePath;

	//!	t@CtH[}bg
	CLockObject<CString>		m_logFormat;

	//!	Url
	CStringArray				m_ignorePath;
};


class CAccessLogFilterFactory :
	public CFilterFactoryBase
{
public:
	CAccessLogFilterFactory(void) {};
	virtual ~CAccessLogFilterFactory(void) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	IFilterPtr FilterFactoryGetFilter()
	{
		return &m_filter;
	};

	//!	
	virtual void _FilterFactoryStart(CIServerToolWrap serverTool)
	{
		m_filter._FilterFactoryStart(serverTool);
	}

	//!	~
	virtual void _FilterFactoryStop()
	{
		m_filter.FilterFactoryStop();
	}

	//!	폜
	virtual void _FilterFactoryDelete() { delete this; }

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^
	CAccessLogFilter			m_filter;
};

