#include "StdAfx.h"
#include "CGIManager.h"
#include "Dir.h"
#include "TextTools.h"

#define	MAX_HEADER_LINE_LENGTH	256

CCGIManager::CCGIManager(void)
{
}

CCGIManager::~CCGIManager(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CCGIManager::Start(CIServerToolWrap serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	擾
	m_serverTool = serverTool;
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());
	m_cgiCommandList = m_setting.GetCGICommandList();

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(CICGIManagerWrap::GetInterfaceName(), this);
}

/*!
	~
*/
void CCGIManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(CICGIManagerWrap::GetInterfaceName(), this);
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	ICGIManager
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	vCGIR}h邩擾

*/
int CCGIManager::TargetIsCGI(LPCSTR targetPath)
{
	//	
	for(int i=0;i<m_cgiCommandList.GetItemCount();i++)
	{
		if(IsMatch(targetPath, m_cgiCommandList.GetItem(i)))
			return(TRUE);
	}
	return(FALSE);
}


/*!
	vCGIR}h擾

	\return	TRUE->v
*/
int CCGIManager::_GetCGICommand(CString targetPath, CCGICommand command)
{
	//	
	for(int i=0;i<m_cgiCommandList.GetItemCount();i++)
	{
		if(IsMatch(targetPath, m_cgiCommandList.GetItem(i)))
		{
			//	擾
			command.Copy(m_cgiCommandList.GetItem(i));
			return(TRUE);
		}
	}
	return(FALSE);
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	c[
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	v邩擾
*/
int CCGIManager::IsMatch(CString targetPath, CCGICommand command)
{
	//	t@Cr
	if(!CTextTools::WildCompare(command.GetPathFilter(), targetPath))
		return(FALSE);

	//	wb_^Cv
	if(command.GetWindowsExecutable())
		return(DetectWindowsExecutable(targetPath));
	else
		return(CheckHeader(targetPath, command.GetHeaderFilter()));
}


/*!
	st@Co
*/
int CCGIManager::DetectWindowsExecutable(CString targetPath)
{
	CString	header = GetFirstLine(targetPath);

	//	MZŎn܂Ă邩H
	if(header.GetLength() >= 2 && header[0] == 'M' && header[1] == 'Z')
		return(TRUE);
	return(FALSE);
}


/*!
	wb_`FbN
*/
int CCGIManager::CheckHeader(CString targetPath, CString headerFilter)
{
	CString	header = GetFirstLine(targetPath);

	//	v邩`FbN
	return CTextTools::WildCompare(headerFilter, header);
}


/*!
	ŏ̈s[h
*/
CString CCGIManager::GetFirstLine(CString targetPath)
{
	CString	ret;
	FILE	*text;

	//	ǂݍł݂
	if(!fopen_s(&text, targetPath, "rb"))
	{
		fgets(ret.GetBuffer(MAX_HEADER_LINE_LENGTH + 1), MAX_HEADER_LINE_LENGTH, text);
		fclose(text);
		ret.ReleaseBuffer();
		return(ret);
	}
	else
		return("");
}
