#pragma once
#include "CGIManager.h"
#include "Context.h"
#include "SubProcess.h"
#include "IConnectionControl.h"
#include "IServerTool.h"
#include "ServerInfoManager.h"

/*!
	CGIwb_
*/
class CCGIHeader :
	public CWorkspaceAccess
{
public:
	//!	FX܂Ƃ߂Đ錾
	DEFINE_COMMON_CONSTRUCTOR(CCGIHeader);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	{
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Status
	DEFINE_PROPERTY_METHOD_INT(Status, "Status", 0);

	//!	Content-Type
	DEFINE_PROPERTY_METHOD_STR(ContentType, "Content-Type", "");

	//!	Content-Length
	DEFINE_PROPERTY_METHOD_INT64(ContentLength, "Content-Length", 0);

	//!	Location
	DEFINE_PROPERTY_METHOD_STR(Location, "Location", "");

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	IvV
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	̑̃wb_(o͂ꂽ`̂܂܂ƂȂ)
	DEFINE_PROPERTY_METHOD_STR(ExtraHeader, "ExtraCGIHeader", "");
};


/*!
	CGIvZXǗNX
*/
class CCGIProcess : public CSubProcess
{
public:
	CCGIProcess(void);
	virtual ~CCGIProcess(void);

	///////////////////////////////////////////////////////////////////////////
	//	s
	///////////////////////////////////////////////////////////////////////////
	//!	CGIR}hC擾
	virtual CString CreateCGICommandLine(CContext context, CCGICommand cgiCommand);

	//!	wb_擾(readBufferւ́Ac肪ݒ肳)
	virtual CString GetHeaderBlock(CBinaryData &readBuffer);

	//!	wb_
	void ParseCGIHeader(CString headerBlock, CCGIHeader headerOption);

	///////////////////////////////////////////////////////////////////////////
	//	ϐ
	///////////////////////////////////////////////////////////////////////////
	//!	T[oϐǉ
	virtual void AddServerInfoToEnv(CServerInfo serverInfo);

	//!	vϐǉ
	virtual void AddRequestInfoToEnv(CContext context);

	//!	XNvgpXCiSSIpj
	virtual void ChangeScriptPath(CString virtualPath, CPathInfo pathInfo);

protected:
	///////////////////////////////////////////////////////////////////////////
	//	⏕֐
	///////////////////////////////////////////////////////////////////////////
	//!	'\'->'/'
	CString BackSlashToSlash(CString str)
	{
		str.Replace("\\", "/");
		return(str);
	}

	///////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////
	//!	̈
	CWorkspace			m_envRoot;

	//!	̈ANZX
	CWorkspaceAccess	m_envAccess;
};


