// DateUtility.cpp: CDateUtility NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DateUtility.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CDateUtility::CDateUtility()
{

}

CDateUtility::~CDateUtility()
{

}

//////////////////////////////////////////////////////////////////////
// GMT擾
//////////////////////////////////////////////////////////////////////
CString CDateUtility::GetGMTString(CTime time)
{
	return(time.FormatGmt("%a, %d %b %Y %H:%M:%S GMT"));
}

//////////////////////////////////////////////////////////////////////
// 擾
//////////////////////////////////////////////////////////////////////
CString CDateUtility::GetTimeString(CTime time)
{
	return(time.Format("%Y/%m/%d %H:%M:%S"));
}

//////////////////////////////////////////////////////////////////////
// 񂩂ϊ
//////////////////////////////////////////////////////////////////////
CTime CDateUtility::StringToCTime(CString time)
{
	time.TrimLeft();
	time.TrimRight();
	time.MakeLower();

	//	H
	if(time.IsEmpty())
		return(-1);

	int	index = time.Find(",");
	int	day,year,month,hour,minute,second;

	if(index == -1)
	{
		// Sun Nov  6 08:49:37 1994       ; ANSI C  asctime() tH[}bg


		//	DayOfWeek
		time = time.Mid(4);

		//	Month
		month = StrToMonth(time.Left(3));
		time = time.Mid(4);

		//	Day
		day = atol(time.Left(2));
		time = time.Mid(3);

		//	Hour
		hour = atol(time.Left(2));
		time = time.Mid(3);

		//	Minute
		minute = atol(time.Left(2));
		time = time.Mid(3);
		
		//	Second
		second = atol(time.Left(2));
		time = time.Mid(3);
	
		//	Year
		year = atol(time.Left(4));

		//	Ŝ
		if(year < 1980 || year > 2900)
			return(CTime(1980,1,1,1,1,1));

		//	
		if(	day < 0)	day = 0;
		if(	day > 31)	day = 31;

		//	
		if(	month < 1)	month = 1;
		if(	month > 12)	month = 12;

		//	
		if(	hour < 0)	hour = 0;
		if(	hour > 23)	hour = 23;

		//	
		if(	minute < 0)		minute = 0;
		if(	minute > 59)	minute = 59;

		//	b
		if(	second < 0)		second = 0;
		if(	second > 59)	second = 59;

		//	Local
		TIME_ZONE_INFORMATION	zoneInfo;
		GetTimeZoneInformation(&zoneInfo);
		CTime ret = CTime(year,month,day,hour,minute,second);
		ret -= CTimeSpan(zoneInfo.Bias * 60);

		return(ret);
	}
	else if(index > 3)
	{
		// Sunday, 06-Nov-94 08:49:37 GMT ; RFC 850, RFC 1036 ɂ莞x

		//	DayOfWeek
		time = time.Mid(index + 2);

		//	Day
		day = atol(time.Left(2));
		time = time.Mid(3);

		//	Month
		month = StrToMonth(time.Left(3));
		time = time.Mid(4);

		//	Year
		year = atol(time.Left(2)) + 2000;
		time = time.Mid(3);

		//	Hour
		hour = atol(time.Left(2));
		time = time.Mid(3);

		//	Minute
		minute = atol(time.Left(2));
		time = time.Mid(3);
		
		//	Second
		second = atol(time.Left(2));
		time = time.Mid(3);

		//	Ŝ
		if(year < 1980 || year > 2900)
			return(CTime(1980,1,1,1,1,1));

		//	
		if(	day < 0)	day = 0;
		if(	day > 31)	day = 31;

		//	
		if(	month < 1)	month = 1;
		if(	month > 12)	month = 12;

		//	
		if(	hour < 0)	hour = 0;
		if(	hour > 23)	hour = 23;

		//	
		if(	minute < 0)		minute = 0;
		if(	minute > 59)	minute = 59;

		//	b
		if(	second < 0)		second = 0;
		if(	second > 59)	second = 59;


		//	Local
		TIME_ZONE_INFORMATION	zoneInfo;
		GetTimeZoneInformation(&zoneInfo);
		CTime ret = CTime(year,month,day,hour,minute,second);
		ret -= CTimeSpan(zoneInfo.Bias * 60);

		return(ret);
	}
	else if(index == 3)
	{
		// Sun, 06 Nov 1994 08:49:37 GMT  ; RFC 822, RFC 1123 ŉ肳ꂽ

		//	DayOfWeek
		time = time.Mid(index + 2);

		//	Day
		day = atol(time.Left(2));
		time = time.Mid(3);

		//	Month
		month = StrToMonth(time.Left(3));
		time = time.Mid(4);

		//	Year
		year = atol(time.Left(4));
		time = time.Mid(5);

		//	Hour
		hour = atol(time.Left(2));
		time = time.Mid(3);

		//	Minute
		minute = atol(time.Left(2));
		time = time.Mid(3);
		
		//	Second
		second = atol(time.Left(2));
		time = time.Mid(3);

		//	Ŝ
		if(year < 1980 || year > 2900)
			return(CTime(1980,1,1,1,1,1));


		//	
		if(	day < 0)	day = 0;
		if(	day > 31)	day = 31;

		//	
		if(	month < 1)	month = 1;
		if(	month > 12)	month = 12;

		//	
		if(	hour < 0)	hour = 0;
		if(	hour > 23)	hour = 23;

		//	
		if(	minute < 0)		minute = 0;
		if(	minute > 59)	minute = 59;

		//	b
		if(	second < 0)		second = 0;
		if(	second > 59)	second = 59;

/*********************************************************************************/
//	year = 3500;	//	DEBUG CODE
/*********************************************************************************/

		//	Local
		TIME_ZONE_INFORMATION	zoneInfo;
		GetTimeZoneInformation(&zoneInfo);
		CTime ret = CTime(year,month,day,hour,minute,second);
		ret -= CTimeSpan(zoneInfo.Bias * 60);

		return(ret);
	}
	return(0);
}


//	̎擾
int CDateUtility::StrToMonth(CString month)
{
	static char emonth[12][10]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
	int		i;

	for(i=0;i<12;i++)
		if(month.CompareNoCase(emonth[i]) == 0)
			return(i+1);
	return(1);
}
