#include "StdAfx.h"
#include "FastReadWriteLock.h"

//	ݗvtO
#define	WRITE_REQUEST_FLAG	0x40000000	

//	ő哯ݐ
#define	MAX_READER_COUNT	0x20000000


CFastReadWriteLock::CFastReadWriteLock(void)
{
	m_writerMutex.Create(FALSE);
	m_readerEvent.Create(TRUE, TRUE);
	m_readerZeroEvent.Create(FALSE, FALSE);
	m_readerCountWriteRequest = 0;
}

CFastReadWriteLock::~CFastReadWriteLock(void)
{
	//	SĊJĂ邩H
	ASSERT(m_readerCountWriteRequest.GetCounter() == 0);
}


/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	ǂݍݗv
*/
void CFastReadWriteLock::ReadLock()
{
	//	ő吔mF
	ASSERT(m_readerCountWriteRequest.GetCounter() < MAX_READER_COUNT);

	//	ݗv?
	while(m_readerCountWriteRequest.IncCounter() & WRITE_REQUEST_FLAG)
	{
		//	JE^߂
		if(m_readerCountWriteRequest.DecCounter() == WRITE_REQUEST_FLAG)
			::SetEvent(m_readerZeroEvent);

		//	ݏI܂ő҂
		WaitForSingleObject(m_readerEvent, INFINITE);
	}
}

/*!
	ǂݍ݊J
*/
void CFastReadWriteLock::ReadUnlock()
{
	//	ĂтH
	ASSERT(m_readerCountWriteRequest.GetCounter() > 0);

	//	JE^߂
	if(m_readerCountWriteRequest.DecCounter() == WRITE_REQUEST_FLAG)
		::SetEvent(m_readerZeroEvent);
}


/*!
	ݗv
*/
void CFastReadWriteLock::WriteLock()
{
	//	ݔr
	WaitForSingleObject(m_writerMutex, INFINITE);

	//	[_[ҋ@CxgZbg
	::ResetEvent(m_readerEvent);

	//	[_[~tO𗧂Ă
	if(m_readerCountWriteRequest.AddCounter(WRITE_REQUEST_FLAG) != 0)
	{
		//	ǂݏoI܂ő҂
		WaitForSingleObject(m_readerZeroEvent, INFINITE);
	}
}

/*!
	݊J
*/
void CFastReadWriteLock::WriteUnlock()
{
	//	ĂтH
	ASSERT(m_readerCountWriteRequest.GetCounter() >= WRITE_REQUEST_FLAG);

	//	tO
	m_readerCountWriteRequest.AddCounter(-WRITE_REQUEST_FLAG);

	//	[_[ҋ@CxgZbg
	::SetEvent(m_readerEvent);

	//	ݔrJ
	::ReleaseMutex(m_writerMutex);
}

