#include "StdAfx.h"
#include "FilterManager.h"
#include "ServerInfoFilter.h"
#include "PathFilter.h"
#include "IndexFilter.h"
#include "AccessLogFilter.h"
#include "KeepAliveFilter.h"

CFilterManager::CFilterManager(void)
{
}

CFilterManager::~CFilterManager(void)
{
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	EI
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CFilterManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	m_serverTool = serverTool;

	//	T[o
	m_filterFactorys.Add(CIFilterFactoryWrapper::CreateWrapper(new CServerInfoFilterFactory));

	//	pX
	m_filterFactorys.Add(CIFilterFactoryWrapper::CreateWrapper(new CPathFilterFactory));

	//	KeepAlive
	m_filterFactorys.Add(CIFilterFactoryWrapper::CreateWrapper(new CKeepAliveFilterFactory));

	//	CfbNX
	m_filterFactorys.Add(CIFilterFactoryWrapper::CreateWrapper(new CIndexFilterFactory));

	//	ANZXO
	m_filterFactorys.Add(CIFilterFactoryWrapper::CreateWrapper(new CAccessLogFilterFactory));

	//	
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		m_filterFactorys[i]->FilterFactoryStart(m_serverTool.GetIServerTool());

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(FILTER_MANAGER_INTERFACE_NAME, this);
}

/*!
	~
*/
void CFilterManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	~
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		m_filterFactorys[i]->FilterFactoryStop();

	m_filterFactorys.RemoveAll();

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(FILTER_MANAGER_INTERFACE_NAME, this);
}


/*!
	tB^z擾
*/
void CFilterManager::GetFilterArray(CFilterArray &filters)
{
	SCOPE_LOCK();
	filters.RemoveAll();

	for(int i=0;i<m_filterFactorys.GetSize();i++)
		filters.Add(CIFilterWrapper::CreateWrapper(m_filterFactorys[i]->FilterFactoryGetFilter()));
}
