#pragma once
#include "InterfaceWrapperMacro.h"
#include "Context.h"

class IPathManager
{
public:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	pX
	virtual int FindPath(LPCSTR path, LPCSTR host, IWorkspaceAccessPtr pathInfo) = 0;

	//!	pX擾
	virtual int GetPathCount() = 0;

	//!	CfbNXpX擾
	virtual int GetPathByIndex(int index, IWorkspaceAccessPtr pathInfo) = 0;
};
//!	|C^^
typedef IPathManager* IPathManagerPtr;


/*!
	IPathManager̃bp
*/
class CIPathManagerWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CIPathManagerWrap, IPathManager, 1);

	///////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	pX
	virtual int FindPath(CString path, CString host, CPathInfo pathInfo)
	{
		return(m_ifPtr->FindPath(path, host, CWorkspaceAccess(pathInfo).GetIWorkspaceAccess()));
	}

	//!	pX擾
	virtual int GetPathCount()
	{
		return(m_ifPtr->GetPathCount());
	}

	//!	CfbNXpX擾
	virtual int GetPathByIndex(int index, CPathInfo pathInfo)
	{
		return(m_ifPtr->GetPathByIndex(index, CWorkspaceAccess(pathInfo).GetIWorkspaceAccess()));
	}
};

