#include "StdAfx.h"
#include "MimeTypeManager.h"
#include "TextTools.h"
#include "SettingTextParser.h"

#define	CLASS_NAME		"MimeTypeManager"
#define	MAX_OPT_INDEX	10	//	œKsőCfbNX

CMimeTypeManager::CMimeTypeManager(void)
{
}

CMimeTypeManager::~CMimeTypeManager(void)
{
	Stop();
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CMimeTypeManager::Start(CIServerToolWrap serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	擾
	m_serverTool = serverTool;
	m_mimeTypeSetting = m_serverTool.GetManagerSetting(m_mimeTypeSetting.GetSettingName());

	//	MimeType
	LoadMimeType();

	//	MimeTypeIcon
	LoadIcon();

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(CIMimeTypeManagerWrap::GetInterfaceName(), this);
}

/*!
	~
*/
void CMimeTypeManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(CIMimeTypeManagerWrap::GetInterfaceName(), this);
}

///////////////////////////////////////////////////////////////////////////////////////////
//	c[֐
///////////////////////////////////////////////////////////////////////////////////////////
/*!
	MimeType[h
*/
void CMimeTypeManager::LoadMimeType()
{
	//	擾
	CSettingTextParserItemArray	parse;
	CSettingTextParser::ParseText(m_mimeTypeSetting.GetMimeTypeText(), parse);
	if(parse.IsEmpty())
	{
		m_serverTool.WriteSystemLog(CLASS_NAME, SERVER_STATUS_WARNING, "MimeType̐ݒ肪ЂƂ܂");
		return;
	}

	//	ϊ
	for(int i=0;i<parse.GetCount();i++)
	{
		parse[i].m_keyText.Trim();
		if(!parse[i].m_keyText.IsEmpty())
		{
			CStringArray	&exts = parse[i].m_dataArray;
			for(int j=0;j<exts.GetCount();j++)
			{
				exts[j].Trim();
				if(!exts[j].IsEmpty())
					m_mimeTypeMap.SetAt(exts[j].MakeLower(), parse[i].m_keyText);
			}
		}
	}
}

/*!
	Icon[h
*/
void CMimeTypeManager::LoadIcon()
{
	//	擾
	CSettingTextParserItemArray	parse;
	CSettingTextParser::ParseText(m_mimeTypeSetting.GetMimeTypeIcocText(), parse);
	if(parse.IsEmpty())
	{
		m_serverTool.WriteSystemLog(CLASS_NAME, SERVER_STATUS_WARNING, "t@C ACR̐ݒ肪ЂƂ܂");
		return;
	}

	//	ϊ
	m_iconArray.RemoveAll();
	for(int i=0;i<parse.GetCount();i++)
	{
		parse[i].m_keyText.Trim();
		if(!parse[i].m_keyText.IsEmpty())
		{
			CStringArray	&mimeExts = parse[i].m_dataArray;
			for(int j=0;j<mimeExts.GetCount();j++)
			{
				mimeExts[j].Trim();
				if(!mimeExts[j].IsEmpty())
					m_iconArray.Add(mimeExts[j].MakeLower(), parse[i].m_keyText);
			}
		}
	}
}


///////////////////////////////////////////////////////////////////////////////////////////
//	C^[tF[X
///////////////////////////////////////////////////////////////////////////////////////////
/*!
	gqMimeType擾
*/
CString CMimeTypeManager::GetMimeTypeByName(CString name)
{
	SCOPE_LOCK();

	//	gq擾
	int index=name.ReverseFind('.');
	if(index == -1)
		return("application/octet-stream");
	CString ext = name.Mid(index + 1).MakeLower();

	//	
	CString	mime;
	if(m_mimeTypeMap.Lookup(ext, mime))
		return(mime);

	//	Ȃ...
	return("application/octet-stream");
}


/*!
	gqACRpX擾
*/
CString CMimeTypeManager::GetIconPathByName(CString name)
{
	SCOPE_LOCK();

	//	MIME^Cv擾
	CString mimeType = GetMimeTypeByName(name);

	//	gq擾
	CString ext;
	int index = name.ReverseFind('.');
	if(index != -1)
		ext = name.Mid(index).MakeLower();

	//	
	for(int i=0;i<m_iconArray.GetSize();i++)
	{
		if(ext == m_iconArray[i].m_key ||
			CTextTools::WildCompare(m_iconArray[i].m_key, mimeType) ||
			CTextTools::WildCompare(m_iconArray[i].m_key, name))
		{
			//	KvȂœK
			if(i < MAX_OPT_INDEX)
			{
				CKeyData	temp = m_iconArray[i];
				m_iconArray.InsertAt(0, temp);
				m_iconArray.RemoveAt(i + 1);
			}

			return(m_iconArray[i].m_data);
		}
	}

	return("");
}

