#include "StdAfx.h"
#include "NewConnectionQueue.h"

CNewConnectionQueue::CNewConnectionQueue(void)
{
	m_semaphore.Create(0, 100000);
	m_maxQueue = 100;
}

CNewConnectionQueue::~CNewConnectionQueue(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////
//	C^[tF[X
///////////////////////////////////////////////////////////////////
/*!
	I
*/
void CNewConnectionQueue::Stop()
{
	SCOPE_LOCK();

	//	폜
	while(m_queue.GetSize())
		m_queue.RemoveHead().Delete();
}

/*!
	ǉ
*/
int CNewConnectionQueue::AddNewConnection(IClientConnectionPtr newConnection)
{
	SCOPE_LOCK();

	if(m_queue.GetSize() >= m_maxQueue)
		return(-1);
	m_queue.AddTail(CIClientConnectionWrapper::CreateWrapper(newConnection));
	::ReleaseSemaphore(m_semaphore, 1, NULL);
	return(0);
}

/*!
	擾
*/
IClientConnectionPtr CNewConnectionQueue::GetNewConnection()
{
	SCOPE_LOCK();

	if(m_queue.GetSize() <= 0)
		return(IClientConnectionPtr());
	return(m_queue.RemoveHead().Detach());
}

/*!
	ő吔ݒ
*/
void CNewConnectionQueue::SetMaxQueue(int max)
{
	m_maxQueue = max;
}

/*!
	݂̕ێ擾
*/
int CNewConnectionQueue::GetCurrentQueueCount()
{
	SCOPE_LOCK();

	return(m_queue.GetSize());
}
