#include "StdAfx.h"
#include "OverloadManager.h"

#define	CLASS_NAME	"OverloadManager"

COverloadManager::COverloadManager(void)
{
}

COverloadManager::~COverloadManager(void)
{
}

/*!
	
*/
void COverloadManager::Start(IServerToolPtr serverTool, int maxConnect, int overloadModeKeepTime)
{
	m_serverTool = serverTool;
	m_maxConnect = maxConnect;
	m_overloadModeKeepTime = overloadModeKeepTime;
	m_overload = 0;

	//	Gg𐶐Ă
	m_serverTool->SetServerStatusInt("ConnectionCount",			0, "݂̐ڑ");
	m_serverTool->SetServerStatusInt("ThreadCount",				0, "݂̃Xbh");
	m_serverTool->SetServerStatusInt("QueueingConnectionCount", 0, "݂̏҂ڑ");
	m_serverTool->SetServerStatusInt("OverloadMode",			0, "I[o[[h");
}


/*!
	T[oׂݒ
*/
void COverloadManager::UpdateServerload(int threadCount, int queueCount)
{
	SCOPE_LOCK();

	//	݂̐ڑ
	int curConnectionCount = threadCount + queueCount;

	//	I[o[[hH
	if(curConnectionCount >= m_maxConnect)
	{
		//	I[o[[h
		if(!m_overload)
			m_serverTool->WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG, "I[o[[h[hֈڍs܂", 1 * 60 * 60 * 1000);

		m_overloadModeStartTime = GetTickCount();
		m_overload = TRUE;
	}
	else
	{
		//	I[o[[hH
		if(m_overload && IsOver(m_overloadModeStartTime, GetTickCount(), m_overloadModeKeepTime))
			m_overload = FALSE;
	}

	//	XV
	m_serverTool->SetServerStatusInt("ConnectionCount",			curConnectionCount);
	m_serverTool->SetServerStatusInt("ThreadCount",				threadCount);
	m_serverTool->SetServerStatusInt("QueueingConnectionCount", queueCount);
	m_serverTool->SetServerStatusInt("OverloadMode",			m_overload);
}

/*!
	w莞ԉ߂H
*/
int COverloadManager::IsOver(DWORD old, DWORD cur, DWORD span)
{
	//	48߂H
	if(old > cur)
		return(TRUE);

	//	o
	if(old + span < cur)
		return(TRUE);

	return(FALSE);
}

