#include "StdAfx.h"
#include "ResponseControl.h"
#include "ResponseManager.h"


CResponseControl::CResponseControl(void)
{
}

CResponseControl::~CResponseControl(void)
{
	FreeResponseModule();
}


/*!
	X|X擾
*/
void CResponseControl::LoadResponseModule(CIConnectionToolWrap connectionTool)
{
	//	Rs[
	m_connectionTool = connectionTool;
	m_threadStatus = m_connectionTool.GetIConnectionThreadStatus();

	//	wb_AX|X𐶐
	m_response = CIResponseWrapper::CreateWrapper(((IResponseManagerPtr)m_connectionTool.GetIServerTool().
		GetManagerInterface(RESPONSE_MANAGER_INTERFACE_NAME, RESPONSE_MANAGER_INTERFACE_VER))->GetResponse(m_connectionTool.GetContxet()));
	if(m_response.IsEmpty())
		throw CConnectionErrorException("X|XW[̎擾Ɏs܂");

	//	W[o^
	m_connectionTool.GetContxet().SetResponseModule(m_response->GetResponseName());

	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_START);

	//	X|XW[
	m_response->ResponseStart(m_connectionTool.GetIConnectionTool());
}



/*!
	I
*/
void CResponseControl::FreeResponseModule()
{
	if(!m_response.IsEmpty())
	{
		//	s̊֐o^
		m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_STOP);

		m_response->ResponseStop(m_connectionTool.GetIConnectionTool());
		m_response.Delete();
	}
}



//////////////////////////////////////////////////////////////////////////////////////////////
//	X|X
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_ݒ
*/
void CResponseControl::SetRequest()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_SET_REQUEST);

	//	s
	m_response->ResponseSetRequest(m_connectionTool.GetIConnectionTool());
}

/*!
	NGXg{fBݒ(JԂ)
*/
void CResponseControl::SetRequestBody(CBinaryData &body)
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_SET_REQUEST_BODY);

	//	s
	m_response->ResponseSetRequestBody(m_connectionTool.GetIConnectionTool(), body.GetCoreInterface());
}

/*!
	NGXg
*/
void CResponseControl::EndRequest()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_END_REQUEST);

	//	s
	m_response->ResponseEndRequest(m_connectionTool.GetIConnectionTool());
}


/*!
	X|X
*/
void CResponseControl::BuildResponse()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_BUILD_RESPONSE);

	//	s
	m_response->ResponseBuildResponse(m_connectionTool.GetIConnectionTool());
}


/*!
	X|Xwb_擾
*/
void CResponseControl::GetResponse()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_GET_RESPONSE);

	//	s
	m_response->ResponseGetResponse(m_connectionTool.GetIConnectionTool());
}

/*!
	X|X{fB擾
*/
int CResponseControl::GetResponseBody(CBinaryData &body, int blockSize)
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_GET_RESPONSE_BODY);

	//	s
	return m_response->ResponseGetResponseBody(m_connectionTool.GetIConnectionTool(), body.GetCoreInterface(), blockSize);
}

/*!
	X|X
*/
void CResponseControl::EndResponse()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_END_RESPONSE);

	//	s
	m_response->ResponseEndResponse(m_connectionTool.GetIConnectionTool());
}

