#include "StdAfx.h"
#include "ServerResponse.h"
#include "HTTPHeaderParser.h"
#include "Settings.h"
#include "TextTools.h"
#include "TextFormatter.h"
#include "resource.h"
#include "ServerTextManager.h"

CServerResponse::CServerResponse(void)
{
}

CServerResponse::~CServerResponse(void)
{
}


/*!
	X|X
*/
void CServerResponse::CreateServerResponse(	CIServerToolWrap						serverTool,
											IConnectionThreadStatusPtr	threadStatus,
											IConnectionControlPtr			connectionControl,
											CContext						context,
											CServerResponseException		&serverResponseException)
{
	//	̐ݒ
	context.SetStatus(serverResponseException.m_status);

	//	X|X̐ݒ
	CContextResponseInfo responseInfo = context.GetResponseInfo();
	responseInfo.Clear();
	responseInfo.SetResponseCode(serverResponseException.m_responseCode);
	responseInfo.SetResponseText(CHTTPHeaderParser::GetResponseText(serverResponseException.m_responseCode));

	//	wb_C
	CContextResponseOption option = responseInfo.GetResponseOption();
	for(int i=0;i<serverResponseException.m_additionalHeader.GetSize();i++)
		option.SetKeyStr(serverResponseException.m_additionalHeader[i].m_key, serverResponseException.m_additionalHeader[i].m_data);
	option.SetContentType("text/html");

	//	ݒ擾
	CServerResponseSetting	setting = serverTool.GetResponseSetting(setting.GetSettingName());

	//	BODYԂH
	switch(serverResponseException.m_responseCode)
	{
	//	BodyԂȂ
	case 304:
		m_responseBody.Empty();
		break;

	//	Html
	default:
		CreateResponseBody(serverTool, setting, serverResponseException, context);
		break;
	}
}


////////////////////////////////////////////////////////////////////////////////////////////
//	c[
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	html
*/
void CServerResponse::CreateResponseBody(CIServerToolWrap serverTool, CServerResponseSetting &setting, CServerResponseException &serverResponseException, CContext &context)
{
	CIServerTextManagerWrap textManager = serverTool.GetIServerTextManager();

	//	R[hʂ̃t@C[h݂
	CString	html = textManager.LoadServerHtmlFile(CTextTools::GetFormat("Response_%03d.html", serverResponseException.m_responseCode));
	if(html.IsEmpty())
	{
		//	ftHgt@C[h݂
		html = textManager.LoadServerHtmlFile("Response_default.html");
		if(html.IsEmpty())
		{
			//	\[X擾
			html = textManager.LoadServerHtmlResource(HTML_RESOURCE_SERVER_RESPONSE);
		}
	}

	//	
	CTextFormatter formatter;

	//	֎~
	formatter.AddEscape("\r", "_");
	formatter.AddEscape("\n", "_");
	formatter.AddEscape("<", "&lt;");
	formatter.AddEscape(">", "&gt;");

	//	T[o
	formatter.AddKeyFromWorkspace(serverTool.GetIServerInfoManager().GetServerInfo());

	//	ReLXg{
	formatter.AddKeyFromWorkspace(context);

	//	Jn
	formatter.AddKeyFromWorkspace(context.GetStartTime());

	//	NCAg
	formatter.AddKeyFromWorkspace(context.GetClientInfo());

	//	NGXg
	formatter.AddKeyFromWorkspace(context.GetRequestInfo());
	formatter.AddKeyFromWorkspace(context.GetRequestInfo().GetRequestOption(), "Req:");

	//	X|X
	formatter.AddKeyFromWorkspace(context.GetResponseInfo());
	formatter.AddKeyFromWorkspace(context.GetResponseInfo().GetResponseOption(), "Res:");

	//	^[Qbg
	formatter.AddKeyFromWorkspace(context.GetTargetInfo());

	//	s
	m_responseBody = formatter.GetFormattedString(html);
}

