#pragma once
#include "InterfaceWrapperMacro.h"
#include "IServerTool.h"
#include "ILogManager.h"
#include "IServerTextManager.h"
#include "IMimeTypeManager.h"
#include "IPathManager.h"
#include "ICGIManager.h"
#include "IServerInfoManager.h"

#include "ServerStatus.h"
#include "ServerInfo.h"


/*!
	IServerTool̃bp
*/
class CIServerToolWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CIServerToolWrap, IServerTool, 1);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	}l[W̌ʐݒ擾
	virtual CWorkspaceAccess GetManagerSetting(CString section)
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), MANAGER_SETTING, section);
		return(temp);
	}

	//!	tB^̌ʐݒ擾
	virtual CWorkspaceAccess GetFilterSetting(CString section)
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), FILTER_SETTING, section);
		return(temp);
	}

	//!	X|X̌ʐݒ擾
	virtual CWorkspaceAccess GetResponseSetting(CString section)
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), RESPONSE_SETTING, section);
		return(temp);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(CString callerName, int statusCode, CString statusInfo, int autoOffTime = -1)
	{
		m_ifPtr->WriteSystemLog(callerName, statusCode, statusInfo, autoOffTime);
	}

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(CString statusName, int status, CString statusInfo = "")
	{
		m_ifPtr->SetServerStatusInt(statusName, status, statusInfo);
	}

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(CString statusName, CString status, CString statusInfo = "")
	{
		m_ifPtr->SetServerStatusStr(statusName, status, statusInfo);
	}

	//!	݂̃T[oXe[^X擾
	virtual CServerStatus GetServerStatus()
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), SERVER_STATUS, NULL);
		return(temp);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[XǗ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface = NULL)
	{
		return m_ifPtr->RegisterManagerInterface(interfaceName, ifRegister, oldInterface);
	}

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface = NULL)
	{
		return m_ifPtr->UnRegisterManagerInterface(interfaceName, ifUnRegister, oldInterface);
	}

	//!	C^tF[X擾
	virtual void *GetManagerInterface(LPCSTR interfaceName, int ifVersion)
	{
		return m_ifPtr->GetManagerInterface(interfaceName, ifVersion);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	pX}l[W擾
	virtual CIPathManagerWrap GetIPathManager()
	{
		return (IPathManagerPtr)m_ifPtr->GetManagerInterface(CIPathManagerWrap::GetInterfaceName(), CIPathManagerWrap::GetInterfaceVersion());
	}

	//!	MimeType}l[W擾
	virtual CIMimeTypeManagerWrap GetIMimeTypeManager()
	{
		return (IMimeTypeManagerPtr)m_ifPtr->GetManagerInterface(CIMimeTypeManagerWrap::GetInterfaceName(), CIMimeTypeManagerWrap::GetInterfaceVersion());
	}

	//!	O}l[W擾
	virtual CILogManagerWrap GetILogManager()
	{
		return (ILogManagerPtr)m_ifPtr->GetManagerInterface(CILogManagerWrap::GetInterfaceName(), CILogManagerWrap::GetInterfaceVersion());
	}

	//!	T[oeLXg}l[W擾
	virtual CIServerTextManagerWrap GetIServerTextManager()
	{
		return (IServerTextManagerPtr)m_ifPtr->GetManagerInterface(CIServerTextManagerWrap::GetInterfaceName(), CIServerTextManagerWrap::GetInterfaceVersion());
	};

	//!	CGI}l[W擾
	virtual CICGIManagerWrap GetICGIManager()
	{
		return (ICGIManagerPtr)m_ifPtr->GetManagerInterface(CICGIManagerWrap::GetInterfaceName(), CICGIManagerWrap::GetInterfaceVersion());
	}

	//!	T[o}l[W擾
	virtual CIServerInfoManagerWrap GetIServerInfoManager()
	{
		return (IServerInfoManagerPtr)m_ifPtr->GetManagerInterface(CIServerInfoManagerWrap::GetInterfaceName(), CIServerInfoManagerWrap::GetInterfaceVersion());
	}
};
