#include "StdAfx.h"
#include "threadskeleton.h"
#include <typeinfo.h>

CThreadSkeleton::CThreadSkeleton()
{
	m_thread = NULL;
	m_hThread = NULL;

	//	fpCxg
	m_breakEvent.Create(TRUE,FALSE);
}

CThreadSkeleton::~CThreadSkeleton(void)
{
	//	Xbh~
	EndThread();

	//	XbhIuWFNg폜
	SAFE_DELETE(m_thread);	//	Xbhnh͗l
}

////////////////////////////////////////////////////////////////////////////////////////////
//	JnEIEf
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh̊Jn
*/
int CThreadSkeleton::StartThread(int stackSize)
{
	//	fCxg
	::ResetEvent(m_breakEvent);

	//	Xbh쐬
	m_thread = AfxBeginThread(WorkThread, this, THREAD_PRIORITY_NORMAL, stackSize*1024, CREATE_SUSPENDED);
	if(m_thread == NULL)
	{
		TRACE("GetLastError :%d\n",GetLastError());
		return(-1);
	}

	//	폜
	m_thread->m_bAutoDelete = FALSE;

	//	nh擾
	m_hThread = m_thread->m_hThread;

	//	XbhsJn
	m_thread->ResumeThread();

	return(0);
}


/*!
	Xbh̏IEI
*/
void CThreadSkeleton::EndThread()
{
	Break();

	//	XbhI܂ő҂
	if(IsRunning())
		::WaitForSingleObject(m_hThread,INFINITE);
}


/*!
	f
*/
void CThreadSkeleton::Break()
{
	::SetEvent(m_breakEvent);
}

/*!
	IiʂȗRAgp֎~j
*/
void CThreadSkeleton::ForceKillThread()
{
	::TerminateThread(m_hThread, 0);
	::SetEvent(m_breakEvent);
}

/*!
	s擾
*/
int CThreadSkeleton::IsRunning()
{
	if(m_hThread == NULL)
		return(0);

	return(::WaitForSingleObject(m_hThread, 0) != WAIT_OBJECT_0);
};


////////////////////////////////////////////////////////////////////////////////////////////
//	c[֐
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	̃IuWFNg҂

	\return	-1:G[A0:^CAEgA1ȍ~:nh	
*/
int CThreadSkeleton::WaitForSomeObjects(int timeoutMs, HANDLE obj1, HANDLE obj2, HANDLE obj3, HANDLE obj4)
{
	HANDLE	wait[4];
	DWORD 	count;

	wait[0] = obj1;
	wait[1] = obj2;
	wait[2] = obj3;
	wait[3] = obj4;

	//	nhJEg
	for(count=0;count<4;count++)
	{
		if(wait[count] == NULL)
			break;
	}

	DWORD ret = ::WaitForMultipleObjects(count,wait,FALSE,timeoutMs);
	if(ret == WAIT_TIMEOUT)
		return(0);

	if(ret >= WAIT_OBJECT_0 && ret < WAIT_OBJECT_0 + count)
		return(ret - WAIT_OBJECT_0 + 1);

	return(-1);
}


////////////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
////////////////////////////////////////////////////////////////////////////////////////////
/*!
	pNXThreadMainĂ
*/
void CThreadSkeleton::_ThreadMain()
{
#ifndef _DEBUG
	try
	{
#endif

		ThreadMain();

#ifndef _DEBUG
	}
	catch(CMemoryException *err)
	{
		FatalError(typeid(this).name(), "sɂAXbh~܂B");
		err->Delete();
	}
	catch(CException *err)
	{
		FatalError(typeid(this).name(), "T[o̖MFCOɂAXbh~܂B");
		err->Delete();
	}
#endif

}


/*!
	s֐
*/
UINT CThreadSkeleton::WorkThread(LPVOID pParam)
{
	CoInitialize(NULL);
	CThreadSkeleton	*thread = (CThreadSkeleton*)pParam;

#ifndef _DEBUG
	__try
	{
#endif

		thread->_ThreadMain();

#ifndef _DEBUG
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		FatalError(typeid(thread).name(), "T[o̖OɂAXbh~܂B");
	}
#endif
	CoUninitialize();

	return(0);
}


/*!
	vIG[
*/
void CThreadSkeleton::FatalError(const char *clsName, const char *errInfo)
{
	//	܂Aۑ𐶐
	char modulePath[MAX_PATH+1];
	DWORD len = GetModuleFileName(NULL, modulePath, MAX_PATH);
	while ( modulePath[len--]!='\\' && len!=0 )
		;
	modulePath[len+2] = '\0';        // }[NŏI点
	strcat_s(modulePath, MAX_PATH, "FatalError.log");

	//	Oo
	FILE *errlog;
	if(fopen_s(&errlog, modulePath, "wt") == 0)
	{
		fprintf(errlog, "%s : %s\n", clsName, errInfo);
		fclose(errlog);
	}
}

