#pragma once
#include "BasicTypeInterfaces.h"

/*!
	z^̐錾
*/
class CWorkspaceNode;
typedef CArray<CWorkspaceNode,CWorkspaceNode&>	CWorkspaceNodeArray;

/*!
	[NXy[XpL^̈
*/
class CWorkspaceKeyData
{
public:
	CWorkspaceKeyData() {};
	CWorkspaceKeyData(CString key,CString data)
	{
		m_key = key;
		m_data = data;
	};

	CString	m_key;
	CString	m_data;
};

/*!
	\class CWorkspaceKeyDataArray
	\brief L[f[^zNX
*/
class CWorkspaceKeyDataArray : public CArray<CWorkspaceKeyData>
{
public:
	//!	ǉ
	void Add(CString key, CString data, int overwrite=TRUE)
	{
		if(overwrite)
		{
			int index = Find(key);

			if(index == -1)
				CArray<CWorkspaceKeyData>::Add(CWorkspaceKeyData(key,data));
			else
				SetAt(index, CWorkspaceKeyData(key,data));
		}
		else
		{
			CArray<CWorkspaceKeyData>::Add(CWorkspaceKeyData(key,data));
		}
	};

	//!	擾
	CString Get(CString key,CString def, int noCase = FALSE)
	{
		int index = Find(key, noCase);

		if(index == -1)
			return(def);
		else
			return(GetAt(index).m_data);
	};

	//!	폜
	void Delete(CString key, int noCase = FALSE)
	{
		int index = Find(key, noCase);

		if(index != -1)
			RemoveAt(index);
	};


	//!	
	int Find(CString key, int noCase = FALSE)
	{
		if(noCase)
		{
			for(int i=0;i<GetSize();i++)
				if(GetAt(i).m_key.CompareNoCase(key) == 0)
					return(i);
			return(-1);
		}
		else
		{
			for(int i=0;i<GetSize();i++)
				if(GetAt(i).m_key == key)
					return(i);
			return(-1);
		}
	}
};


/*!
	[NXy[X̃m[hێNX
*/
class CWorkspaceNode
{
	friend class CWorkspaceXMLReader;
	friend class CWorkspaceXMLWriter;

public:
	CWorkspaceNode(void);
	CWorkspaceNode(CString name);
	~CWorkspaceNode(void);

	/*********************************************************
		Ȃ
	**********************************************************/
	//!	CArrayŗp邽߂́ARs[Zq
	void operator=(const CWorkspaceNode &other);

	//!	Sf[^NA
	void Clear(void);

	//!	m[h̐ݒ
	void SetNodeName(CString name) { m_nodeName = name; };

	//!	m[h̎擾
	CString GetNodeName() { return(m_nodeName); };


	/*********************************************************
		KeyɊւ鏈
	**********************************************************/
	//!	f[^̐ݒ
	void SetKeyData(CString key, CString data,int noCase);

	//!	f[^̎擾
	CString GetKeyData(CString key, CString defaultData, int noCase);

	//!	f[^̍폜
	void DeleteKey(CString key);

	//!	L[擾
	int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	int GetAllKey(IStringArrayPtr list);

	//!	SẴf[^𕶎ƂĎ擾
	int GetAllData(IStringArrayPtr list);

	//!	L[
	int FindKeyData(CString sData, int noCase = FALSE, int pathCompare = FALSE);

	//!	L[܂Ƃ߂Đݒ
	void ClearAndSetKeys(CStringArray &keys, CStringArray &datas);

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	Tum[h
	CWorkspaceNode *GetSubNode(CString path, CString &key);

	//!	Tum[hǉ
	void AddSubNode(CString name);

	//!	m[h폜
	void DeleteNode(CString name);

	//!	Tum[h𓾂
	int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	int GetAllSubNode(IStringArrayPtr list);


protected:
	/******************************************************
		o͂Ɋւ鏈
	*******************************************************/
	//!	Tum[h쐬
	CWorkspaceNode *AddNewSubNode(CString name);

	//!	Tum[hCfbNXŎ擾
	CWorkspaceNode *GetSubNodeByIndex(int index);

	//!	L[CfbNXŎ擾
	CWorkspaceKeyData *GetKeyByIndex(int index);

protected:
	/******************************************************
		KeyɊւ鏈
	*******************************************************/
	//!	Key̌
	int FindKeyIndex(CString &key,int noCase);

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	Tum[h
	int FindSubNodeIndex(CString name);

	/******************************************************
		̑̊֐
	*******************************************************/
	//!	pX̉
	int ParsePath(CString path, CString & topPath, CString & subPath);


protected:
	//!	̃m[h̎f[^
	CWorkspaceKeyDataArray			m_keyData;

	//!	Tum[g
	CWorkspaceNodeArray		m_subNode;

	//!	̃m[h̖O
	CString					m_nodeName;
};

