#include "StdAfx.h"
#include "04WebServer.h"
#include "connection.h"
#include "threadskeleton.h"
#include "server.h"
#include "dateutility.h"
#include "intervaltimer.h"
#include "StringCompare.h"
#include "Dir.h"
#include "subprocess.h"

#include "systemresponse.h"
#include "normalresponse.h"
#include "directoryresponse.h"
#include "fileresponse.h"
#include "cgiresponse.h"
#include "ssiresponse.h"

#include "davpropfindresponse.h"
#include "fileputresponse.h"
#include "filedeleteresponse.h"
#include "filemoveresponse.h"
#include "optionsresponse.h"
#include "keyswapstring.h"
#include "SSLProtocolSocket.h"


CConnection::CConnection(CServer *server, CAcceptedSocket newSockete)
: m_interrupt(this)
{
	DEBUG_SET_THREAD_CLASS_NAME("CConnection");

	//	ϐ
	m_server = server;
	m_maxKeepAliveTime = m_server->m_setting.GetConfig("Basic::KeepAliveTime", 20) * 1000;
	m_keepAlive = m_server->m_setting.GetConfig("Basic::EnableKeepAlive", 0);
	m_serverTimeout = m_server->m_setting.GetConfig(_T("Basic::TimeOut"), 300) * 1000;

	//	\Pbgݒ
	m_rawSocket = newSockete.GetSocket();
	m_rawSocketType = newSockete.GetSocketType();

	//	XbhJn
	if(StartThread())
		throw CConnectionException("Xbh̊JnɎs܂");
}

CConnection::~CConnection(void)
{
	EndThread();

	SAFE_DELETE(m_protocolSocket);
}


/*!
	f
*/
void CConnection::Break()
{
	CThreadSkeleton::Break();
}


/*!
	ڑ
*/
void CConnection::ThreadMain()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::ThreadMain");

	//	\Pbg
	m_protocolSocket = CreateProtocolSocket(m_rawSocket, m_rawSocketType);
	if(m_protocolSocket == NULL)
	{
		closesocket(m_rawSocket);
		return;
	}

	//	KeepAlive[v
	while(1)
	{
		DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::ThreadMain::KeepAliveLoop");

		//	ANZX́H
		if(!m_protocolSocket->WaitNextRequest(m_maxKeepAliveTime))
			break;	//	^CAEgؒf

		//	V
		CWorkspaceAccess context = NewContext();

		//	PNGXg̏s
		try
		{
			//	
			m_sendSize = 0;
			m_recvSize = 0;
			m_recvDataSize = 0;

			//	ڑ
			int KeepAlive = OneRequest(context);

			//	]ʋL^
			UpdateTransSize(context);

			//	ɏÎŃT[oOɏo
			WriteLog(context);

			//	폜
			DeleteContext(context);

			//	ؒfH
			if(KeepAlive == 0)
				break;
		}
		catch(CServerFatalException e)
		{
			//	]ʋL^
			UpdateTransSize(context);

			//	ؒf̕Kv̂G[̂ŁAOɃG[o
			context.SetConfig("Info", e.m_info);
			WriteLog(context);

			//	폜
			DeleteContext(context);
			return;
		}

		//	KeepAlive͗Lł͂ȂH T[oׁ͍H
		if(m_keepAlive==0 || m_server->ServerIsOverload())
			break;
	}

	//	\Pbg
	SAFE_DELETE(m_protocolSocket);
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	ڑ
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Ή\Pbgbp
*/
CProtocolSocket *CConnection::CreateProtocolSocket(SOCKET socket, int socketType)
{
	try
	{
		switch(socketType)
		{
			case SOCKET_TYPE_HTTP:
			default:
			{
				CProtocolSocket *protocolSocket = new CProtocolSocket();
				protocolSocket->AttachSocket(socket);
				protocolSocket->SetBreakEvent(GetBreakEvent());
				protocolSocket->SetTimeout(m_serverTimeout);
				return(protocolSocket);
			}

			case SOCKET_TYPE_HTTPS:
			{
				CSSLProtocolSocket *protocolSocket = new CSSLProtocolSocket();
				protocolSocket->AttachSocket(socket);
				protocolSocket->SetBreakEvent(GetBreakEvent());
				protocolSocket->SetTimeout(m_serverTimeout);

				//	SSLJn
				if(protocolSocket->SSLAccept(m_server->GetCTX()))
				{
					delete protocolSocket;
					return(NULL);
				}
				return(protocolSocket);
			}
		}
	}
	catch(CMemoryException *err)
	{
		err->Delete();
		return(NULL);
	}
}



/*!
	PNGXg̏s
*/
int CConnection::OneRequest(CWorkspaceAccess context)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::OneRequest::Step1");

	/*
		NGXg̎MƉ͂s
	*/
	//	zXg
	context.SetConfig("Host", (CString)m_protocolSocket->GetPeerAddres());

	//	wb_[̎M
	CString		header = RecvHeader();

	//	NGXg̉
	CRequest	request(header, context.GetAccess("RequestInfo"));

	//	^[QbgzXg
	context.SetConfig("TargetHost", request.m_options.GetConfig("Host", "", TRUE));

	//	pX̉
	CAlias		alias(request.m_uriObject, request.m_options.GetConfig("Host", "", TRUE), m_server->m_setting);

	//	ш敝Ǘ
	CBandWidthReference	bandRef(m_server->GetCBandWidthMgr(), m_protocolSocket->GetPeerAddres(), context.GetConfig("ThreadName", ""));

	//	X|X
	CResponse *use = NULL;

	//	Keep-Alivẻ
	int KeepAlive;
	if(request.m_options.GetConfig("Connection", "", TRUE).CompareNoCase("keep-alive") == 0)
		KeepAlive = 1;
	else
		KeepAlive = 0;


	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::OneRequest::Step2");

	//	T[o[G[XR[v(500)
	try
	{
		//	T[o[X|XXR[v(301, 404 etc...)
		try
		{
			//	WX|XXR[v
			try
			{
				//	T[oߕ׏Ԃ`FbN
				CheckServerOverload(context);

				//	[U[F؁EڑȂǁAANZX`FbN
				CheckAccess(context, request, alias, bandRef);

				//	WebDAV
				WebDAV(context, request, alias);

				//	ړH
				CheckMove(context, request, alias);

				/*
					ȍ~AIndext@Cɉe
				*/
				//	CfbNXt@Cֈړ
				CheckIndex(context, request, alias);

				//	CGI?
				CGI(context, request, alias);

				//	SSI?
				SSI(context, request, alias);


				//	fBNg\H
				if(alias.IsDirectory() && !alias.IsIndexExist())
					throw new CDirectoryResponse(m_server, context, request, alias);

				//	ŏI̓t@C
				throw new CFileResponse(m_server, context, request, alias);
			}
			catch(CNormalResponse *response)
			{
				DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::OneRequest::CNormalResponse");

				//	OÃXR[vō폜
				use = response;

				//	X|XM
				SendResponse(context, request, alias, bandRef, response);
				delete response;

				//	bZ[W
				context.SetConfig("Info", "ɏI܂");

				//	I
				return KeepAlive;
			}
		}
		catch(CSystemResponse *response)
		{
			DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::OneRequest::CSystemResponse");

			//	̃XR[ṽf[^폜
			if(use != NULL)
				delete use;

			//	OÃXR[vō폜
			use = response;

			//	X|XM
			SendResponse(context, request, alias, bandRef, response);
			
			//	bZ[W
			context.SetConfig("Info", response->GetInfo());

			delete response;

			//	I
			return KeepAlive;
		}
	}
	catch(CServerFatalException e)
	{
		DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::OneRequest::CServerFatalException");

		//	̃XR[ṽf[^폜
		if(use != NULL)
			delete use;

		//	vIT[oG[
		SendFatalError(e.m_info);

		//	G[o^
		context.SetConfig("ResponseInfo::ResponseCode", 500);
		context.SetConfig("ResponseInfo::ResponseText", CResponse::GetHTTPResponseString(500));

		//	ɓ
		throw CServerFatalException(e.m_info);
	}
	catch(CMemoryException *err)
	{
		DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::OneRequest::CMemoryException");

		err->Delete();

		//	̃XR[ṽf[^폜
		if(use != NULL)
			delete use;

		//	vIT[oG[
		SendFatalError("NGXg̏ɁAs܂");

		//	G[o^
		context.SetConfig("ResponseInfo::ResponseCode", 500);
		context.SetConfig("ResponseInfo::ResponseText", CResponse::GetHTTPResponseString(500));

		//	ɓ
		throw CServerFatalException("NGXg̏ɁAs܂");
	}

	//	ɂ͗Ȃ
	ASSERT(0);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	X|X쐬
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ׂ`FbN
*/
void CConnection::CheckServerOverload(CWorkspaceAccess &context)
{
	//	ׂH
	if(m_server->ServerIsOverload())
		throw new CSystemResponse(m_server, context, _T("T[o׏Ԃ̂߁AꎞIɃT[rX~Ă܂B"), 503);
}

/*!
 *	ANZXL`FbN
 */
void CConnection::CheckAccess(CWorkspaceAccess &context, CRequest &request, CAlias &alias, CBandWidthReference &bandRef)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CheckAccess");

	//	HTTPsH
	if(m_protocolSocket->GetSocketType() == SOCKET_TYPE_HTTP && alias.GetPathOptions().GetConfig("AcceptHTTP", 1)==0)
		throw new CSystemResponse(m_server, context, m_server->m_setting.GetConfig("InfoMessage::DeniedHTTP", "HTTP ̃ANZX́AĂ܂"), m_server->m_setting.GetConfig("InfoMessage::DeniedHTTPCode", 403));

	//	HTTPSsH
	if(m_protocolSocket->GetSocketType() == SOCKET_TYPE_HTTPS && alias.GetPathOptions().GetConfig("AcceptHTTPS", 1)==0)
		throw new CSystemResponse(m_server, context, m_server->m_setting.GetConfig("InfoMessage::DeniedHTTPS", "HTTPS ̃ANZX́AĂ܂"), m_server->m_setting.GetConfig("InfoMessage::DeniedHTTPSCode", 403));

	//	LbNH
	if(CheckKickHost(context, request, alias))
		throw new CSystemResponse(m_server, context, m_server->m_setting.GetConfig("InfoMessage::KickHost", "ANZX́AĂ܂"), m_server->m_setting.GetConfig("InfoMessage::KickHostCode", 403));
		
	//	ڑ`FbN
	if(bandRef.IsLimitOver())
		throw new CSystemResponse(m_server, context, m_server->m_setting.GetConfig("InfoMessage::ConnectLimit", "PzXg̍őڑ𒴂܂"), m_server->m_setting.GetConfig("InfoMessage::ConnectLimitCode", 503));

	//	Bt@C͖H
	if(alias.GetPathOptions().GetConfig("EnableHiddenFile", 0) == 0 && alias.IsHidden())
		throw new CSystemResponse(m_server, context, m_server->m_setting.GetConfig("InfoMessage::HiddenDisable", "̃t@CEfBNgւ̃ANZX́AĂ܂"), m_server->m_setting.GetConfig("InfoMessage::HiddenDisableCode", 403));

	//	[U[`FbN
	CheckUser(context, request, alias);
}


/*!
	ړ̊mF
*/
void CConnection::CheckMove(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CheckMove");

	if(alias.IsMove())
	{
		CSystemResponse *move = new CSystemResponse(m_server, context, alias.GetMoveTo() + " ɈړĂ", 301);
		move->m_responseOptions.SetConfig("Location", alias.GetMoveTo());
		throw move;
	}
}


/*!
 *	WebDAV
 */
void CConnection::WebDAV(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::WebDAV");

	//	Options
	if(request.m_method == "OPTIONS")
		throw new COptionsResponse(m_server, context, request, alias);

	//	WebDAV͗L?
	if(alias.GetPathOptions().GetConfig("EnableWebDAV", 0))
	{
		if(request.m_method == "PROPFIND")
			throw new CDAVPropfindResponse(m_server, context, request, alias);
		else if(request.m_method == "PROPPATCH")
			throw new CSystemResponse(m_server, context, _T("w肳ꂽ\bh́AT|[gĂ܂B"), 500);
		else if(request.m_method == "LOCK")
			throw new CSystemResponse(m_server, context, _T("w肳ꂽ\bh́AT|[gĂ܂B"), 500);
		else if(request.m_method == "UNLOCK")
			throw new CSystemResponse(m_server, context, _T("w肳ꂽ\bh́AT|[gĂ܂B"), 500);
	}

	//	݂͗LH
	if(alias.GetPathOptions().GetConfig("EnableWrite", 0))
	{
		if(request.m_method == "PUT")
			throw new CFilePutResponse(m_server, context, request, alias);
		else if(request.m_method == "MKCOL")
			throw new CFilePutResponse(m_server, context, request, alias);
		else if(request.m_method == "DELETE")
			throw new CFileDeleteResponse(m_server, context, request, alias);
		else if(request.m_method == "COPY")
			throw new CFileMoveResponse(m_server, context, request, alias);
		else if(request.m_method == "MOVE")
			throw new CFileMoveResponse(m_server, context, request, alias);
	}
}


/*!
	IndexmF
*/
void CConnection::CheckIndex(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CheckIndex");

	//	CfbNXH
	if(alias.IsIndexExist())
	{
		//	uEU̕ňړH
		if(m_server->m_setting.GetConfig("Basic::IndexNoMove", 0))
		{
			//	ړȂ̂ŁAړ
			alias.InternalMove(alias.GetIndexFile());
		}
		else
		{
			//	uEU̕ňړ
			CSystemResponse *move = new CSystemResponse(m_server, context, alias.GetIndexFile() + " ɈړĂ", 301);
			move->m_responseOptions.SetConfig("Location", alias.GetIndexFile());
			throw move;
		}
	}
}


/*!
	CGI
*/
void CConnection::CGI(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CGI");

	//	t@C͂̂H
	if(!alias.IsExist()  && !alias.IsExtarExist())
		return;

	//	CGI͋Ă̂H
	if(alias.GetPathOptions().GetConfig("EnableSSICGI", 0))
	{
		CString command;

		//	GNXgpX
		if(alias.IsExtarExist())
			command = CSubProcess::GetCGICommand(m_server, alias.GetExtraTarget(), request.m_queryDecoded);
		else
			command = CSubProcess::GetCGICommand(m_server, alias.GetTarget(), request.m_queryDecoded);

		if(!command.IsEmpty())
		{
			context.SetConfig("ScriptCommand", command);
			throw new CCGIResponse(m_server, context, request, alias, m_interrupt);
		}
	}
}


/*!
	SSI
*/
void CConnection::SSI(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::SSI");

	//	t@C͂̂H
	if(!alias.IsExist())
		return;

	//	SSI͋Ă̂H
	if(alias.GetPathOptions().GetConfig("EnableSSICGI", 0))
	{
		//	gq̎擾
		CString	ext = CDir::PathToExt(alias.GetTarget());

		//	ݒ胊Xg擾
		CWorkspaceAccess	ssiSetting = m_server->m_setting.GetAccess("SSI");
		CStringArray	ssiList;
		ssiSetting.GetAllKey(ssiList);

		//	eݒ
		for(int i=0;i<ssiList.GetSize();i++)
		{
			if(ext.CompareNoCase(ssiSetting.GetConfig(ssiList[i], "")) == 0)
				throw new CSSIResponse(m_server, context, request, alias, m_interrupt);
		}
	}
}

/*!
	LbNzXg`FbN
*/
int CConnection::CheckKickHost(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CheckKickHost");

	CWorkspaceAccess	kick = alias.GetPathInfo().GetAccess("Kick");
	CString				hostIP = m_protocolSocket->GetPeerAddres();

	//	LH
	if(alias.GetPathOptions().GetConfig("EnableHostKick", 0))
	{
		//	܂͋֎~Ă邩`FbN
		CWorkspaceAccess	denied = kick.GetAccess("Denied");
		CStringArray	list;
		denied.GetAllKey(list);

		for(int i=0;i<list.GetSize();i++)
		{
			if(CStringCompare::WildCompare(denied.GetConfig(list[i], ""), hostIP))
				return(1);
		}

		//	Ă邩`FbN
		CWorkspaceAccess	accept = kick.GetAccess("Accept");
		accept.GetAllKey(list);

		for(int i=0;i<list.GetSize();i++)
		{
			if(CStringCompare::WildCompare(accept.GetConfig(list[i], ""), hostIP))
				return(0);
		}

		return(1);
	}

	return(0);
}


/*!
 *	[U[̃`FbN
 *
 */
void CConnection::CheckUser(CWorkspaceAccess &context, CRequest &request, CAlias &alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CheckUser");

	if(alias.GetPathOptions().GetConfig("EnableAuthenticate", 0))
	{
		CString	username = request.m_user;
		if(alias.GetPathOptions().GetConfig("EnableWebDAV", 0))
		{
			//	WindowsXP ΍
			int index = username.Find("\\");
			if(index != -1)
				username = username.Mid(index+1);
		}

		if(CheckUser(username, request.m_passwd, alias)==0)
		{
			CSystemResponse *move = new CSystemResponse(m_server, context, "F؂Kvł", 401);
			CString str;
			str.Format("Basic realm=\"%s\"", alias.GetPathInfo().GetConfig("Info", ""));
			move->m_responseOptions.SetConfig("WWW-Authenticate", str);
			throw move;
		}
	}
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	X|X
////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*!
 *	wb_[̎M
 *
 */
CString CConnection::RecvHeader()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::RecvHeader");

	//	wb_M
	CString	header;
	if(m_protocolSocket->RecvProtocolHeader(header, _T("\r\n\r\n"), MAX_HTTP_HEADER_SIZE, FALSE))
		throw CServerFatalException("wb_[M" + m_protocolSocket->GetLastErrorString());

	//	MTCY
	m_recvSize += header.GetLength();

	return(header);
}

/*!
	X|X̏
*/
void CConnection::SendResponse(CWorkspaceAccess &context, CRequest &request, CAlias &alias, CBandWidthReference &bandRef, CResponse *response)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::SendResponse");

	//	bZ[W
	context.SetConfig("Info", "X|Xf[^̑O...");

	//	X|X
	response->PreCreateResponse();

	//	X|X{fB[̎M
	RecvData(context, request, alias, bandRef, response);

	//	X|X𐶐
	context.SetConfig("Info", "X|Xf[^̐...");
	response->CreateResponse();

	//	X|X̎擾
	CWorkspaceAccess responseInfo = response->GetResponseInfo();
	CWorkspaceAccess responseOptions = responseInfo.GetAccess("Options");

	//	̎擾
	__int64 length = response->GetResponseSize();
	responseOptions.SetConfig("Content-Length", length);

	//	wb_̐
	CString header = MakeHeaderString(responseInfo);

	//	bZ[W
	context.SetConfig("Info", "wb_[̑Mł...");

	//	wb_̑M
	if(m_protocolSocket->SendString(header)<0)
		throw CServerFatalException(_T("wb_[M") + m_protocolSocket->GetLastErrorString());

	//	wb_TCY
	m_sendSize += header.GetLength();

	//	{fB[M
	SendData(context, request, alias, bandRef, response, length);
}

/*!
	NGXg{fB[M
*/
void CConnection::RecvData(CWorkspaceAccess &context, CRequest &request, CAlias &alias, CBandWidthReference &bandRef, CResponse *response)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::RecvData");

	context.SetConfig("Info", "f[^̎MJnĂ܂...");

	//	MTCÝH
	__int64 len = _atoi64(request.m_options.GetConfig("Content-Length", "0", TRUE));
	__int64	orgLen;

	//	2ڂ̌Ăяỏ\l(c̃f[^݂̂擾)
	len -= m_recvDataSize;
	orgLen = len;

	//	~bg̐ݒ
	bandRef.SetRecvLimit(alias.GetPathOptions().GetConfig("EnableBandWidthLimit", 0));

	//	M
	CBuffer				recvBuf;
	CBandWidthLimit		limiter;
	CIntervalTimer		timer(1000);
	while(len > 0)
	{
		//	M
		int recv = m_protocolSocket->RecvBinary(recvBuf, RECV_BUF_SIZE);
		if(recv < 0)
			throw CServerFatalException(_T("f[^M") + m_protocolSocket->GetLastErrorString());
		else if(recv == 0)
			continue;

		//	M
		response->SetNextData(recvBuf);

		//	JEg
		len -= recv;
		m_recvSize += recv;
		m_recvDataSize += recv;

		//	ш搧ɂEFCg
		Delay(limiter.GetWaitTick(bandRef.GetCurrentRecvLimit(), recv));
		limiter.OneTracsEnd();

		//	
		if(timer)
		{
			int limit = bandRef.GetCurrentRecvLimit();

			CString	str;
			if(!limit)
				str.Format("M : %I64dK/%I64dK [%I64d%%] (%0.1fK/Sec)", orgLen - len, orgLen, (orgLen - len) * 100 / orgLen, (double)limiter.GetCurSpeed()/1024.0);
			else
				str.Format("M : %I64dK/%I64dK [%I64d%%] (%0.1fK/S, Limit: %0.1fK/S)", orgLen - len, orgLen, (orgLen - len) * 100 / orgLen, (double)limiter.GetCurSpeed()/1024.0, (double)limit/1024.0);
			context.SetConfig("Info", str);
		}
	}

	//	~bg
	bandRef.SetRecvLimit(0);
}

/*!
	X|X{fB[𑗐M
*/
void CConnection::SendData(CWorkspaceAccess &context, CRequest &request, CAlias &alias, CBandWidthReference &bandRef, CResponse *response, __int64 length)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::SendData");

	context.SetConfig("Info", "f[^̑MJnĂ܂...");

	//	~bg̐ݒ
	bandRef.SetSendLimit(alias.GetPathOptions().GetConfig("EnableBandWidthLimit", 0));


	//	Body̑M
	CBuffer			sendBuf(SEND_BUF_SIZE);
	CBandWidthLimit	limiter;
	CIntervalTimer	timer(1000);
	__int64			sended = 0;
	while(1)
	{
		//	f[^󂯎
		int size = response->GetNextData(sendBuf);
		if(size <= 0)
			break;

		//	M
		if(size > 0)
		{
			if(m_protocolSocket->Send(sendBuf, size)<0)
				throw CServerFatalException(_T("f[^M") + m_protocolSocket->GetLastErrorString());

			//	JEg
			m_sendSize += size;
			sended += size;
		}

		//	ш搧ɂEFCg
		Delay(limiter.GetWaitTick(bandRef.GetCurrentSendLimit(), size));
		limiter.OneTracsEnd();

		//	
		if(timer)
		{
			int limit = bandRef.GetCurrentSendLimit();

			CString	str;
			if(!limit)
				str.Format("M : %I64dK/%I64dK [%I64d%%] (%0.1fK/Sec)", sended, length, sended * 100 / length, (double)limiter.GetCurSpeed()/1024.0);
			else
				str.Format("M : %I64dK/%I64dK [%I64d%%] (%0.1fK/S, Limit: %0.1lfK/S)", sended, length, sended * 100 / length, (double)limiter.GetCurSpeed()/1024.0, (double)limit/1024.0);
			context.SetConfig("Info", str);
		}
	}

	//	~bg
	bandRef.SetRecvLimit(0);
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	⏕֐
////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*!
	wb_̐
*/
CString CConnection::MakeHeaderString(CWorkspaceAccess responseInfo)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::MakeHeaderString");

	CWorkspaceAccess responseOptions = responseInfo.GetAccess("Options");
	CString	header, line;

	//	X|XC
	line.Format("HTTP/1.1 %s\r\n", responseInfo.GetConfig("ResponseText", "500 Internal Server Error"));
	header += line;

	//	IvVC
	CStringArray	keyList;
	responseOptions.GetAllKey(keyList);
	for(int i=0;i<keyList.GetSize();i++)
	{
		line.Format("%s: %s\r\n", keyList[i], responseOptions.GetConfig(keyList[i], ""));
		header += line;
	}

	//	CGIpwb_
	CString cgiHeader = responseInfo.GetConfig("CGIHeader", "");
	header += cgiHeader;
	header += "\r\n";

	return(header);
}


/*!
	vIG[̏
*/
void CConnection::SendFatalError(CString info)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::SendFatalError");

	CString	body;
	body.Format("<HTML><HEAD>"\
				"<TITLE>500 Internal Server Error</TITLE>"\
				"<meta http-equiv=\"Content-Type\" content=\"text/html;charset=Shift_JIS\"></HEAD>\n"\
				"<BODY><H1>Error : 500 Internal Server Error</H1>"\
				"<PRE>%s</PRE>"\
				"<HR><ADDRESS>04WebServer/"SERVER_VER"</ADDRESS>"\
				"</BODY></HTML>", info);

	CString	head;
	head.Format("HTTP/1.0 500 Internal Server Error\r\n"\
				"Server: 04WebServer/"SERVER_VER"\r\n"\
				"Content-Type: text/html\r\n"\
				"Connection: Close\r\n"\
				"Content-length: %d\r\n"\
				"\r\n", body.GetLength());

	m_protocolSocket->SendString(head);
	m_protocolSocket->SendString(body);
	m_protocolSocket->Close();
}


/*!
	VReLXg̎擾
*/
CWorkspaceAccess CConnection::NewContext()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::NewContext");

	//	[NXy[X쐬
	CString	name;
	name.Format("Thread_%04x", m_server->GetNewID());

	CWorkspaceAccess	ret = m_server->m_threadContext.GetAccess(name);
	ret.SetConfig("ThreadName", name);

	//	쐬ݒ
	CWorkspaceAccess	date = ret.GetAccess("StartTime");
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::NewContext::GetDate");
	date.Copy(GetDate());

	//	bZ[W
	ret.SetConfig("Info", "ł...");

	//	^Cv
	if(m_protocolSocket->GetSocketType() == SOCKET_TYPE_HTTPS)
	{
		ret.SetConfig("Protocol", "https");
	}
	else
	{
		ret.SetConfig("Protocol", "http");
	}

	return(ret);
}

/*!
	O
*/
void CConnection::WriteLog(CWorkspaceAccess &context)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::WriteLog");

	//	uƃ\[Xݒ
	CKeySwapString	swapper;
	CString			format = m_server->m_setting.GetConfig("Log::LogFormatNoTime", "[%Time%] <%Host%> (%RecvSize%, %SendSize%) [%Info%] %Method% %Object%");
	swapper.SetString(format);

	CWorkspaceAccess	request = context.GetAccess("RequestInfo");
	CWorkspaceAccess	response = context.GetAccess("ResponseInfo");

	//	Userݒ肳ĂȂꍇ "-" ɒu
	if(request.GetConfig("User", "").IsEmpty())
		swapper.Swap("User", "-");

	//	ReLXg
	swapper.Swap(context);

	//	W
	swapper.Swap(request);
	swapper.Swap(response);

	swapper.Swap(request.GetAccess("Options"));
	swapper.Swap(response.GetAccess("Options"));

	//	s폜
	CString	logLine = swapper.GetString("-");
	logLine.Replace("\n", "_");
	logLine.Replace("\r", "_");

	m_server->m_log.WriteLog("%s", logLine);
}


/*!
	ReLXg̔j
*/
void CConnection::DeleteContext(CWorkspaceAccess context)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::DeleteContext");

	CString	name = context.GetConfig("ThreadName", "");
	int max = m_server->m_setting.GetConfig("Log::MaxThreadLog", 10);

	//	t̎擾
	CWorkspaceAccess	date = context.GetAccess("EndTime");
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::DeleteContext::GetDate");
	date.Copy(GetDate());

	if(max > 0)
	{
		//	bN
		WORKSPACE_LOCK(m_server->m_threadContextLog);

		//	̈̃Rs[
		CWorkspaceAccess	log = m_server->m_threadContextLog.GetAccess(name);
		log.Copy(context);

		//	O̒
		if(m_server->m_threadContextLog.GetSubNodeCount() > max)
		{
			CStringArray	array;
			m_server->m_threadContextLog.GetAllSubNode(array);
			m_server->m_threadContextLog.DeleteNode(array[0]);
		}
	}

	//	̍폜
	m_server->m_threadContext.DeleteNode(name);
}


//	]ʂL^
void CConnection::UpdateTransSize(CWorkspaceAccess &context)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::UpdateTransSize");

	//	]ʓo^
	m_server->AddTrans(m_sendSize, m_recvSize);

	//	TCY̋L^
	context.SetConfig("RecvSize", m_recvSize);
	context.SetConfig("SendSize", m_sendSize);
	context.SetConfig("Size", m_recvSize + m_sendSize);
}



/*!
 *	t擾
 *
 *	@param	detail	1:ڍחL
 *	@return			̈
 */
CWorkspaceAccess CConnection::GetDate(int detail)
{
//	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::GetDate");

	//	̈擾
	CWorkspaceAccess date = m_date.GetAccess("Date");
	date.Clear();

	//	
	CTime	time=CTime::GetCurrentTime();
	date.SetConfig("Date", time.Format("%Y/%m/%d"));
	date.SetConfig("Time", time.Format("%H:%M:%S"));
	date.SetConfig("GMT", CDateUtility::GetGMTString(time));

	if(detail)
	{
		date.SetConfig("Year", time.Format("%Y"));
		date.SetConfig("Month", time.Format("%m"));
		date.SetConfig("Day", time.Format("%d"));
		date.SetConfig("DayOfWeek", time.Format("%w"));

		date.SetConfig("MonthString", time.Format("%b"));
		date.SetConfig("DayOfWeekString", time.Format("%a"));

		date.SetConfig("Hour", time.Format("%H"));
		date.SetConfig("Minute", time.Format("%M"));
		date.SetConfig("Second", time.Format("%S"));

	}
	return(date);
}


/*!
 *	[U[̃`FbN
 */
int CConnection::CheckUser(CString userName, CString passwd, CAlias alias)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::CheckUser");

	CWorkspaceAccess	pathUser = alias.GetPathInfo().GetAccess("Users");
	CWorkspaceAccess	enableUser = m_server->m_setting.GetAccess("User::Enable");

	//	
	CStringArray	userList;
	pathUser.GetAllKey(userList);
	for(int i=0;i<userList.GetSize();i++)
	{
		if(pathUser.GetConfig(userList[i], "") == userName)
			goto next;
	}
	return 0;

next:

	//	
	enableUser.GetAllSubNode(userList);
	for(int i=0;i<userList.GetSize();i++)
	{
		CWorkspaceAccess user = enableUser.GetAccess(userList[i]);
		if(user.GetConfig("User", "") == userName && user.GetConfig("Passwd", "") == passwd)
			return 1;
	}
	return 0;
}


/*!
 *	EFCg
 */
void CConnection::Delay(int tick)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CConnection::Delay");

	DWORD	endTick = GetTickCount() + tick;

	while(!m_interrupt.IsInterrupt())
	{
		int subTick = endTick - GetTickCount();
		
		if(subTick <= 0)
		{
			break;
		}
		else if(subTick < 20)
		{
			Sleep(subTick);
			break;
		}
		else
			Sleep(20);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	荞݊ǗNX
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
CConnectionInterrupt::CConnectionInterrupt(CConnection *connection)
{
	m_connection = connection;
}

CConnectionInterrupt::CConnectionInterrupt(CConnectionInterrupt &other)
{
	m_connection = other.m_connection;
	m_interruptInfo = other.m_interruptInfo;
}

//	荞݂H
int CConnectionInterrupt::IsInterrupt()
{
	//	ؒf`FbN
	if(m_connection->m_protocolSocket->IsDisconnect())
	{
		m_interruptInfo = "ؒf܂";
		return(1);
	}

	//	f`FbN
	if(m_connection->GetBreak())
	{
		m_interruptInfo = "f܂";
		return(1);
	}

	return(0);
}

//	Iy[^
CConnectionInterrupt::operator int()
{
	return(IsInterrupt());
}

//	擾
CString CConnectionInterrupt::GetInterruptInfo()
{
	return(m_interruptInfo);
}

