#include "StdAfx.h"
#include "ExpatXmlParser.h"

CExpatXmlParser::CExpatXmlParser(void)
{
	m_init = FALSE;
}

CExpatXmlParser::~CExpatXmlParser(void)
{
	Close();
}



/////////////////////////////////////////////////////////////////////////////////////
//	Jn
/////////////////////////////////////////////////////////////////////////////////////
/*!
	t@C擾
*/
void CExpatXmlParser::ScanXmlFile(CString path)
{
	//	J
	CBinaryData	load;
	if(load.LoadFromFile(path))
		throw CXMLTextParserException(_T("t@C̃I[vɎs܂"));

	StartScan(load);
}


/*!
	XL
*/
void CExpatXmlParser::StartScan(CBinaryData &xml)
{
	//	
	if(Init())
		throw CXMLTextParserException(_T("XMLp[T[̏Ɏs܂"));

	//	
	if(XML_Parse(m_parser, (const XML_Char*)xml.GetPtr(), (int)xml.GetSize(), TRUE) != XML_TRUE)
		throw CXMLTextParserException(_T("XML̉͂Ɏs܂"));
}


/////////////////////////////////////////////////////////////////////////////////////
//	⏕
/////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CExpatXmlParser::Init()
{
	if(!m_init)
	{
		//	
		m_parser = XML_ParserCreateNS(NULL, 0);
		if(m_parser == NULL)
			return(-1);

		//	[U[f[^Zbg
		XML_SetUserData(m_parser, this);

		//	nhZbg
		XML_SetElementHandler(m_parser, StartElementHandler, EndElementHandler);
		XML_SetCharacterDataHandler(m_parser, CharacterDataHandler);
		XML_SetNamespaceDeclHandler(m_parser, StartNamespaceDeclHandler, EndNamespaceDeclHandler);
		m_init = TRUE;
	}
	else
	{
		//	Zbg
		if(XML_ParserReset(m_parser, NULL) != XML_TRUE)
			return(-1);
	}
	return(0);
}

/*!
	I
*/
void CExpatXmlParser::Close()
{
	if(m_init)
	{
		XML_ParserFree(m_parser);
	}
	m_init = FALSE;
}


/*!
	Attr`FbN
*/
int CExpatXmlParser::GetAttrCount(const XML_Char **atts)
{
	//	
	int i;
	for(i=0;atts[i];i++)
		;
	return(i);
}


/////////////////////////////////////////////////////////////////////////////////////
//	R[obN
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CExpatXmlParser::StartElementHandler(void *userData, const XML_Char *name, const XML_Char **atts)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnStartTag(name, atts, CExpatXmlParser::GetAttrCount(atts));
}

/*!
	I^O
*/
void CExpatXmlParser::EndElementHandler(void *userData, const XML_Char *name)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnEndTag(name);
}

/*!
	f[^
*/
void CExpatXmlParser::CharacterDataHandler(void *userData, const XML_Char *s, int len)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnData((const char*)s, len);
}


/*!
	l[Xy[XJn
*/
void CExpatXmlParser::StartNamespaceDeclHandler(void *userData,  const XML_Char *prefix, const XML_Char *uri)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnStartNS((const char*)prefix, (const char*)uri);
}

/*!
	l[Xy[XI
*/
void CExpatXmlParser::EndNamespaceDeclHandler(void *userData,  const XML_Char *prefix)
{
	CExpatXmlParser *obj = (CExpatXmlParser*)userData;

	//	R[
	obj->OnEndNS((const char*)prefix);
}
