#include "StdAfx.h"
#include "ListenerManager.h"

CListenerManager::CListenerManager(void)
{
}

CListenerManager::~CListenerManager(void)
{
	Stop();
}

/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CListenerManager::Start(CWorkspaceAccess setting)
{
	ASSERT(!m_init);

	//	
	m_init = TRUE;

	//	T[oݒ
	CWorkspaceAccess basic = setting.GetAccess("Basic");
	CWorkspaceAccess enhance = setting.GetAccess("Enhance");

	//	ݒ擾
	int MaxQueue = basic.GetKeyInt("MaxConnect", 100) * 2;	//	Xbh*2
	int ListenRetryTime = enhance.GetKeyInt("ListenRetryTime", 30) * 1000;

	//	ߕאݒ擾
	m_overloadThreshold = enhance.GetKeyInt("OverloadThresholdQueuedConnection", 50) * MaxQueue / 100;
	if(m_overloadThreshold < 0)
		m_overloadThreshold = 0;
	if(m_overloadThreshold > MaxQueue)
		m_overloadThreshold = MaxQueue;

	//	L[TCYݒ
	m_acceptedQueue.SetMaxQueue(MaxQueue);

	//	HTTPXi
	m_httpListener.InitListener(&m_acceptedQueue, SOCKET_TYPE_HTTP, ListenRetryTime);

	//	HTTP|[gǉ
	m_httpListener.AddPortsFromSetting(setting.GetKeyStr(_T("Basic::Port"), _T("80")));

	//	HTTPs
	m_httpListener.StartListener();

	//	HTTPS͗LH
	if(basic.GetKeyInt(_T("EnableSSL"), 0))
	{
		//	HTTPXi
		m_httpsListener.InitListener(&m_acceptedQueue, SOCKET_TYPE_HTTPS, ListenRetryTime);

		//	HTTP|[gǉ
		m_httpsListener.AddPortsFromSetting(setting.GetKeyStr(_T("SSL::Port"), _T("443")));

		//	HTTPs
		m_httpsListener.StartListener();
	}
}

/*!
	~
*/
void CListenerManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	HTTPXi~
	m_httpListener.StopListener();

	//	HTTPSXi~
	m_httpsListener.StopListener();
}

/*!
	~
*/
void CListenerManager::ShutdownListen()
{
	if(!m_init)
		return;

	//	HTTPXi~
	m_httpListener.StopListener();

	//	HTTPSXi~
	m_httpsListener.StopListener();
}

/*!
	I[o[[hԂ擾
*/
int CListenerManager::QueueIsOverload()
{
	if(m_acceptedQueue.GetIAcceptedSockeQueueAccesse()->GetCurrentQueueCount() >= m_overloadThreshold)
		return(TRUE);
	return(FALSE);
}
