#include "StdAfx.h"
#include "OverlappedSocket.h"
#include "ThreadSkeleton.h"

COverlappedSocket::COverlappedSocket(void)
{
	//	Cxg
	m_closeEvent.Create(TRUE,FALSE);
	m_event.Create(TRUE, FALSE);

	m_socket = INVALID_SOCKET;
	m_timeout = INFINITE;
	m_breakEvent = NULL;

	SetLastError(OVRS_ERROR_NO_ERROR);
}

COverlappedSocket::~COverlappedSocket(void)
{
	Close();
}


//////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////
/*!
	gpJn
*/
int COverlappedSocket::AttachSocket(SOCKET sock)
{
	m_socket = sock;

	//	CxgNA
	::ResetEvent(m_closeEvent);
	::ResetEvent(m_event);

	//	\PbgƂCxgŌo
	if(::WSAEventSelect(m_socket, m_closeEvent, FD_CLOSE))
	{
		SetLastError(OVRS_ERROR_OTHER);
		return(-1);
	}
	return(0);
}

/*!
	
*/
void COverlappedSocket::Close()
{
	if(m_socket != INVALID_SOCKET)
	{
		//	\Pbgnh֘At
		::WSAEventSelect(m_socket, m_closeEvent, 0);

		//	\Pbg
		shutdown(m_socket,1);

		//	\Pbg
		closesocket(m_socket);

		m_socket = INVALID_SOCKET;
	}
}


//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	obt@𑗐M(ubLO)

	return -1:G[A0:ؒfA>0:
*/
int COverlappedSocket::BlockingSend(char *buf, int len, int timeOut)
{
	SetLastError(OVRS_ERROR_NO_ERROR);

	//	ς݁H
	if(m_socket == INVALID_SOCKET)
		return(-1);

	//	^CAEg͐ݒ肳ĂH
	if(timeOut == -1)
		timeOut = m_timeout;

	//	Cxg
	::ResetEvent(m_event);

	//	I[o[bv\̏
	WSAOVERLAPPED	ovr;
	INIT_OVERLAPPED(ovr, m_event);

	//	obt@
	WSABUF	wsaBuf;
	wsaBuf.buf = buf;
	wsaBuf.len = len;

	//	M
	DWORD	sended = 0;
	if(::WSASend(m_socket, &wsaBuf, 1, &sended, 0, &ovr, NULL) == SOCKET_ERROR)
	{
		//	G[H
		if(WSAGetLastError() != WSA_IO_PENDING)
		{
			SetLastError();
			return(-1);
		}

		//	I҂
		switch(CThreadSkeleton::WaitForSomeObjects(timeOut, m_event, m_closeEvent, m_breakEvent))
		{
		//	^CAEg
		case 0:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_TIMEOUT);
			return(-1);

		//	ؒf
		case 2:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_CLOSE);
			return(0);

		//	f
		case 3:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_BREAK);
			return(-1);

		//	
		case 1:
		default:
			break;
		}

		//	ʎ擾
		DWORD	flags;
		if(!WSAGetOverlappedResult(m_socket, &ovr, &sended, FALSE, &flags))
		{
			SetLastError();
			return(-1);
		}

		//	ؒfH
		if(sended == 0)
		{
			SetLastError(OVRS_ERROR_CLOSE);
			return(0);
		}
	}

	return(sended);
}

/*!
	obt@֎M(ubLO)

	return -1:G[A0:ؒfA>0:
*/
int COverlappedSocket::BlockingRecv(char *buf, int len, int timeOut)
{
	//	ς݁H
	if(m_socket == INVALID_SOCKET)
		return(-1);

	//	^CAEg͐ݒ肳ĂH
	if(timeOut == -1)
		timeOut = m_timeout;

	//	Cxg
	::ResetEvent(m_event);

	//	I[o[bv\̏
	WSAOVERLAPPED	ovr;
	INIT_OVERLAPPED(ovr, m_event);

	//	obt@
	WSABUF	wsaBuf;
	wsaBuf.buf = buf;
	wsaBuf.len = len;

	//	M
	DWORD	recved = 0, flags = 0;
	if(::WSARecv(m_socket, &wsaBuf, 1, &recved, &flags, &ovr, NULL) == SOCKET_ERROR)
	{
		if(WSAGetLastError() != WSA_IO_PENDING)
		{
			SetLastError();
			return(-1);
		}

		//	I҂
		switch(CThreadSkeleton::WaitForSomeObjects(timeOut, m_event, m_closeEvent, m_breakEvent))
		{
		//	^CAEg
		case 0:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_TIMEOUT);
			return(-1);

		//	ؒf
		case 2:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_CLOSE);
			return(0);

		//	f
		case 3:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_BREAK);
			return(-1);

		//	
		case 1:
		default:
			break;
		}

		//	ʎ擾
		DWORD	flags;
		if(!WSAGetOverlappedResult(m_socket, &ovr, &recved, FALSE, &flags))
		{
			SetLastError();
			return(-1);
		}

		//	ؒfH
		if(recved == 0)
		{
			SetLastError(OVRS_ERROR_CLOSE);
			return(0);
		}
	}

	return(recved);
}

/*!
	ؒfĂ邩擾
*/
int COverlappedSocket::IsDisconnect()
{
	if(m_socket == INVALID_SOCKET)
		return(TRUE);

	//	Cxg҂
	switch(CThreadSkeleton::WaitForSomeObjects(0, m_closeEvent))
	{
	case 0:
		return(FALSE);

	case 1:
	default:
		SetLastError(OVRS_ERROR_CLOSE);
		return(TRUE);

	}
}


/*!
	ŏIG[ݒ
*/
void COverlappedSocket::SetLastError(int error)
{
	if(error != OVRS_ERROR_AUTO_SET)
	{
		m_lastError = error;
	}
	else
	{
		switch(WSAGetLastError())
		{
		case WSAECONNRESET:
			m_lastError = OVRS_ERROR_CLOSE;
			break;

		default:
			m_lastError = OVRS_ERROR_OTHER;
			break;
		}
	}
}

