/*!
	XV
	2005/05/21 ParseHeader,IvVwb_̐؂oC
*/

#include "StdAfx.h"
#include "request.h"
#include "connection.h"
#include "UrlUtility.h"
#include "Base64.h"

CRequest::CRequest(CString &header,CWorkspaceAccess requestInfo)
{
	if(ParseHeader(header,requestInfo))
		throw CServerFatalException("ُȃwb_[M܂");
}

CRequest::~CRequest(void)
{
}


/*!
 *	wb_[
 *
 */
int CRequest::ParseHeader(CString &header,CWorkspaceAccess requestInfo)
{
	CString	line;


	//	NGXgo
	if(GetLine(header,line)==0)
		return(-1);
	
	//	\bh
	if(GetToken(line,m_method," ")==0)
		return(-1);

	//	URI
	if(GetToken(line,m_uri," ")==0)
		return(-1);

	//	URIObject
	m_uriObject = CUrlUtility::GetUrlObject(m_uri);
	m_uriObject = CUrlUtility::DecodeUrl(m_uriObject);

	//	Query
	m_query = CUrlUtility::GetQuery(m_uri);
	m_queryDecoded = CUrlUtility::Decode(m_query);

	//	o[W
	if(GetToken(line,m_version,"/")==0)
		return(-1);
	if(line.GetLength() == 0)
		return(-1);
	m_version = line;


	//	̂߁AbN
	WORKSPACE_LOCK(requestInfo);


	//	IvVwb_[擾
	CWorkspaceAccess options = requestInfo.GetAccess("Options");
	CString	key;
	while(1)
	{
		if(GetLine(header,line)==0)
			break;

		//	key
		if(GetToken(line,key,": ")==0)		//	xxx: xxxx
			if(GetToken(line,key,":")==0)	//	xxx:xxxx
				continue;

		//	data
		if(line.GetLength() == 0)
			continue;

		options.SetConfig(key,line);
	}

	//	[U[ƃpX[h
	CString	encoded = options.GetConfig("Authorization","");
	if(encoded.GetLength() > 6)
	{
		if(encoded.Left(6).CompareNoCase("Basic ") == 0)
		{
			encoded = encoded.Mid(6);
			CString	userpass = CBase64::Decode64(encoded);

			int	index = userpass.Find(":");
			if(index != -1)
			{
				m_user = userpass.Left(index);
				m_passwd = userpass.Mid(index + 1);
			}
		}
	}

	//	֐ݒ
	requestInfo.SetConfig("Method",m_method);
	requestInfo.SetConfig("URL",m_uri);
	requestInfo.SetConfig("Object",m_uriObject);
	requestInfo.SetConfig("Version",m_version);
	requestInfo.SetConfig("Query",m_query);
	requestInfo.SetConfig("QueryDecoded",m_queryDecoded);
	requestInfo.SetConfig("User",m_user);
	requestInfo.SetConfig("Passwd",m_passwd);

	m_requestInfo = requestInfo;
	m_options = options;

	return(0);
}

//////////////////////////////////////////////////////////////////////
// C؂o
//////////////////////////////////////////////////////////////////////
int CRequest::GetLine(CString &str, CString &line)
{
	int index = str.Find("\r\n");

	if(index == -1)
		return(0);
	
	//	؂o
	line = str.Left(index);

	//	폜
	str = str.Mid(index + 2);
	return(1);
}

//////////////////////////////////////////////////////////////////////
// g[N؂o
//////////////////////////////////////////////////////////////////////
int CRequest::GetToken(CString &str, CString &token, CString div)
{
	int tlen = div.GetLength();
	int index = str.Find(div);

	if(index == -1)
		return(0);
	
	//	؂o
	token = str.Left(index);

	//	폜
	str = str.Mid(index + tlen);
	return(1);

}

