#pragma once

#include "Workspace.h"
#include "threadskeleton.h"
#include "logwriter.h"
#include "mimetypemgr.h"
#include "bandwidthmgr.h"
#include "ListenerManager.h"
#include "IntervalTimer.h"
#include "SSLContext.h"



/*!
	class CSettingSwap

	T[oݒ̒u
*/
class CSettingSwap : public IWorkspaceAutoSwap
{
public:
	CSettingSwap(CWorkspaceAccess serverInfo) {m_serverInfo = serverInfo;};
	CString SwapString(CString key,CString data);
	void Delete() { delete this; };

	CWorkspaceAccess	m_serverInfo;	
};


/*!
	class CServer

	T[os܂
*/
class CServer : public CThreadSkeleton
{
public:
	CServer(void);
	virtual ~CServer(void);

	int GetNewID();
	CMimeTypeMgr GetCMimeTypeMgr() {SCOPE_LOCK(); return m_mimeTypes;};
	CBandWidthMgr *GetCBandWidthMgr() {return &m_bandWidthMgr;};
	void AddTrans(__int64 send,__int64 recv) {m_bandWidthMgr.AddTrans(send,recv);};
	void SetServerStatus(CString status, CTimeSpan viewTime = CTimeSpan(1,0,0,0));

	//!	ڑ擾
	int GetConnectCount();

	//!	I[o[[hԂ擾
	int ServerIsOverload();

	//!	SSLReLXg擾
	SSL_CTX *GetCTX() { return m_sslContext.GetCTX(); };

private:
	void InitServerInfo(void);				//!<	T[o̐ݒ
	int StartListen(void);					//!<	҂󂯊Jn
	void ThreadMain();						//!<	Xbh{
	void KillAllConnection();				//!<	SĂ̐ڑ̒~

	//!	SSL
	void InitSSL();

	//!	̐ڑ҂
	void WaitNextConnection(int timeout);

	//!	̃ANZX擾
	int GetNextAccess(CAcceptedSocket &nextAccess, int waitTime);

	//!	ؒfڑj
	void ClearCompletedConnections();

	//!	T[oג
	void CheckServerLoad();

	//!	T[oXV
	void UpdateServerInfo();

protected:
	//////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////
	//!	őڑ
	int					m_maxConnect;

	//!	ڑ
	CPtrArray			m_connections;

	//!	IDJE^
	int					m_IDCounter;

	//!	MimeTypẽLbV
	CMimeTypeMgr		m_mimeTypes;

	//!	ш搧
	CBandWidthMgr		m_bandWidthMgr;

	//!	Xi
	CListenerManager	m_listener;

	//!	SSLReLXg
	CSSLContext			m_sslContext;

	//!	׃tO
	CInterlockCounter	m_overloadFlag;

	//!	ׂƔf臒l
	int					m_overloadThreshold;

	//!	׏Ԉێ^C}
	CIntervalTimer		m_overloadKeepTimer;


public:
	CWorkspace			m_context;				//!<	ReLXg[g
	CWorkspace			m_settingRoot;			//!<	ݒ胋[g
	CWorkspace			m_infoRoot;				//!<	T[o񃋁[g
	CWorkspaceAccess	m_setting;				//!<	ݒ
	CWorkspaceAccess	m_threadContext;		//!<	Xbh̈
	CWorkspaceAccess	m_threadContextLog;		//!<	Xbh̈̃O
	CWorkspaceAccess	m_serverInfo;			//!<	T[o̈

	//!	T[oXe[^X
	CTime				m_statusHideTime;

	CLogWriter			m_log;					//!<	OC^[
};

