#include "StdAfx.h"
#include "DAVPropfindReqParser.h"

CDAVPropfindReqParser::CDAVPropfindReqParser(void)
{
}

CDAVPropfindReqParser::~CDAVPropfindReqParser(void)
{
}

/*!
	p[Xs
*/
int CDAVPropfindReqParser::ParsePropfind(CBinaryData &xml, CWorkspaceAccess propertys)
{
	try
	{
		m_propertys = propertys;
		m_inPropfind = 0;
		m_inProp = 0;

		StartScan(xml);
	}
	catch(CXMLTextParserException err)
	{
		TRACE(_T("%s\n"), err.GetErrorInfo());
		return(-1);
	}
	return(0);
}


/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CDAVPropfindReqParser::OnStartTag(LPCSTR tag, LPCSTR *atts, int attsCount)
{
	CString	csTag = tag;

	//	^Oŕ
	if(csTag.CompareNoCase("DAV:propfind") == 0)
	{
		if(m_inPropfind)
			throw CXMLTextParserException(_T("DAV:PropfindqɂȂĂ܂"));
		m_inPropfind = 1;
	}
	else if(csTag.CompareNoCase("DAV:prop") == 0)
	{
		if(!m_inPropfind)
			throw CXMLTextParserException(_T("DAV:Propfind̊ODAV:Prop܂"));
		if(m_inProp)
			throw CXMLTextParserException(_T("DAV:PropqɂȂĂ܂"));
		m_inProp = 1;
	}
	else
	{
		if(m_inProp)
		{
			//	Worspace֎~
			if(csTag.Find(_T("::")) == -1)
			{
				m_propertys.SetKeyInt(csTag, 0);
				TRACE("DAV:Propaty : %s\n", csTag);
			}
		}
	}
}

/*!
	I^O
*/
void CDAVPropfindReqParser::OnEndTag(LPCSTR tag)
{
	CString	csTag = tag;

	if(csTag.CompareNoCase("DAV:propfind") == 0)
	{
		m_inPropfind = 0;
	}
	else if(csTag.CompareNoCase("DAV:prop") == 0)
	{
		m_inProp = 0;
	}
}

/*!
	f[^
*/
void CDAVPropfindReqParser::OnData(const char *data, int len)
{
}
