/*!
 *  \file Registry04.h
 *  \brief WXgNX CRegistry04 ̃C^[tFCX
 *  \author kishy
 *
 *  \since 2002/6/8
 */

#if !defined(AFX_REGISTRY04_H__B4E1D123_4278_4F87_BEC2_8EBF82D9C05B__INCLUDED_)
#define AFX_REGISTRY04_H__B4E1D123_4278_4F87_BEC2_8EBF82D9C05B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CRegistry04

//! WXgNX
class CRegistry04
{
#	if defined(REG_QWORD)
	//! \name NX^
	public:
	//@{
		typedef unsigned __int64 QWORD;
	//@}
#	endif

	//! \name \zE
	public:
	//@{
		CRegistry04();
		virtual ~CRegistry04() throw();
	//@}

	//! WXgpf[^
	protected:
	//@{
		BOOL m_fAttached;			//!< nh̃A^b`ɂ鐶

		HKEY m_hKey;				//!< WXgL[nh
		HKEY m_hParentKey;			//!< eWXgL[nh
		REGSAM m_mode;				//!< L[̃ANZX[h
		DWORD m_disposition;		//!< VKL[

		CString m_pathName;			//!< pXi[p

		DWORD m_nSubKeys;			//!< ʂɊ܂܂TuL[̐
		DWORD m_nMaxSubKeyNameLen;	//!< ʂɊ܂܂TuL[̍ő咷
		int m_nEnumIndex;			//!< 񋓎̃CfbNX

		DWORD m_nValues;			//!< ʂɊ܂܂l̐
		DWORD m_nMaxValueNameLen;	//!< ʂɊ܂܂l̍ő咷
		DWORD m_nMaxValueDataLen;	//!< ʂɊ܂܂l̍ő咷

		CString m_subKeyName;		//!< TuL[i[p
	//@}

	//! \name tO
	public:
	//@{
		BOOL m_bMessage;			//!< G[bZ[W\tO
	//@}

	//! \name J
	public:
	//@{
		BOOL Open(HKEY hKey, const CString &subKeyName, const CString &mode = _T("a"));
		BOOL Open(const CRegistry04 &reg, const CString &subKeyName, const CString &mode = _T("a"));
		void Close() throw();
	//@}

	//! \name XV
	public:
	//@{
		BOOL Refresh();
	//@}

	//! \name A^b`Ef^b`
	public:
	//@{
		BOOL Attach(HKEY hKey, const CString &keyName = _T(""), HKEY hParentKey = 0);
		HKEY Detach() throw();
	//@}

	//! \name TuL[񋓏
	public:
	//@{
		DWORD EnumSubKey(BOOL fInitialize = FALSE);
	//@}

	//! \name 폜
	public:
	//@{
		BOOL DeleteValue(const CString &valueName);
		BOOL DeleteSubKey(const CString &subKeyName);
	//@}

	//! \name L[l擾
	public:
	//@{
		BOOL QueryValue(LPBYTE &pValue, DWORD &nValueLen, const CString &valueName);
		BOOL QueryValue(DWORD &value, const CString &valueName);
		BOOL QueryValue(CString &value, const CString &valueName);
		BOOL QueryValue(CStringArray &value, const CString &valueName);
	//@}

	//! \name L[lݒ菈
	public:
	//@{
		BOOL SetValue(const CString &valueName, LPBYTE pValue, DWORD nValueLen);
		BOOL SetValue(const CString &valueName, DWORD value);
		BOOL SetValue(const CString &valueName, const CString &value);
		BOOL SetValue(const CString &valueName, const CStringArray &value);
	//@}

	//! \name TuL[l擾
	public:
	//@{
		BOOL QuerySubKeyValue(const CString &subKeyName, LPBYTE &pValue, DWORD &nValueLen, const CString &valueName);
		BOOL QuerySubKeyValue(const CString &subKeyName, DWORD &value, const CString &valueName);
		BOOL QuerySubKeyValue(const CString &subKeyName, CString &value, const CString &valueName);
		BOOL QuerySubKeyValue(const CString &subKeyName, CStringArray &value, const CString &valueName);
	//@}

	//! \name TuL[lݒ菈
	public:
	//@{
		BOOL SetSubKeyValue(const CString &subKeyName, const CString &valueName, LPBYTE pValue, DWORD nValueLen);
		BOOL SetSubKeyValue(const CString &subKeyName, const CString &valueName, DWORD value);
		BOOL SetSubKeyValue(const CString &subKeyName, const CString &valueName, const CString &value);
		BOOL SetSubKeyValue(const CString &subKeyName, const CString &valueName, const CStringArray &value);
	//@}

#if defined(REG_QWORD)
	//! \name QWORDn
	public:
	//@{
		BOOL QueryValue(QWORD &value, const CString &valueName);
		BOOL SetValue(const CString &valueName, QWORD value);
		BOOL QuerySubKeyValue(const CString &subKeyName, QWORD &value, const CString &valueName);
		BOOL SetSubKeyValue(const CString &subKeyName, const CString &valueName, QWORD value);
	//@}
#endif

	//! \name ݒ菈
	public:
	//@{
		void EnableMessage(BOOL bMessage = TRUE) { m_bMessage = bMessage; }
	//@}

	//! \name vpeB擾
	public:
	//@{
		HKEY GetHandle() const { return m_hKey; }
		BOOL IsCreatedKey() const { return m_disposition == REG_CREATED_NEW_KEY; }
		BOOL IsExistingKey() const { return m_disposition == REG_OPENED_EXISTING_KEY; }

		CString GetSubKeyName() const { return m_subKeyName; }
		CString GetPathName() const { return m_pathName; }

		DWORD GetSubKeys() const { return m_nSubKeys; }
		DWORD GetMaxSubKeyNameLen() const { return m_nMaxSubKeyNameLen; }
		DWORD GetMaxValueNameLen() const { return m_nMaxValueNameLen; }
		DWORD GetMaxValueDataLen() const { return m_nMaxValueDataLen; }
	//@}

	//! \name Cve[V
	protected:
	//@{
		void Clean() throw();
		BOOL QueryInfoKey();
		CString HKEY2String(HKEY hKey);

		void MessageBox(const CString &msg);
	//@}
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_REGISTRY04_H__B4E1D123_4278_4F87_BEC2_8EBF82D9C05B__INCLUDED_)
