#include "StdAfx.h"
#include "AuthenticateManager.h"
#include "TextTools.h"
#include "Base64.h"
#include "CryptTools.h"
#include "DigestAuthenticate.h"

#define	PRIVATE_KEY_LENGTH	8
#define	TIME_LENGTH			16
#define	NONCE_MIN_LENGTH	(PRIVATE_KEY_LENGTH + 1 + TIME_LENGTH + 1)

CAuthenticateManager::CAuthenticateManager(void)
{
}

CAuthenticateManager::~CAuthenticateManager(void)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//	C^tF[X
/////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CAuthenticateManager::Start(CWorkspaceAccess setting)
{
	m_setting = setting;

	//	XNuL[ݒ
	srand((unsigned int)CTime::GetCurrentTime().GetTime() + GetTickCount());
	m_scrambleKey.AppendDoubleWord(rand());
	m_scrambleKey.AppendDoubleWord(rand());
	m_scrambleKey.AppendDoubleWord(rand());
	m_scrambleKey.AppendDoubleWord(rand());

	//	vCx[gL[擾
	for(int i=0;i<PRIVATE_KEY_LENGTH;i++)
		m_privateKey += (TCHAR)((rand() % 27) + _T('a'));

	//	Noncep\
	m_expireTime = setting.GetKeyInt(_T("Authenticate::NonceLifeTime"), 60) * 60;	//	60
/*

	CWorkspace	test;
	CDigestAuthenticate::ParseAuthOptionLine("Digest username=\"\", realm=\"Secret, Zone,\", nonce=\"RMH1usDrAwA=6dc290ea3304de42a7347e0a94089ff5912ce0de\", uri=\"/~68user/net/sample/http-auth-digest/secret.html\", algorithm=MD5, qop=auth, nc=00000001,  cnonce=\"e79e26e0d17c978d\", response=\"0d73182c1602ce8749feeb4b89389019\"", test.GetAccess(""));
//CheckNonce(CreateNonce());
*/
}


/*!
	[ŨpX[hmF

	\return FALSE:Fؕs, TRUE:FOK
*/
int CAuthenticateManager::GetUserPasswd(CString userName, CString &passwd)
{
	CWorkspaceAccess	enableUser = m_setting.GetAccess("User::Enable");

	//	Lȃ[U
	CStringArray	userList;
	enableUser.GetAllSubNode(userList);
	for(int i=0;i<userList.GetSize();i++)
	{
		CWorkspaceAccess user = enableUser.GetAccess(userList[i]);
		if(user.GetConfig(_T("User"), _T("")) == userName)
		{
			passwd = user.GetConfig(_T("Passwd"), _T(""));
			return(TRUE);
		}
	}
	return(FALSE);
}

/*!
	nonce
*/
CString CAuthenticateManager::CreateNonce(CString tag)
{
	//	
	CString	src = CTextTools::GetFormat(_T("%016I64x:%s:%s"), CTime::GetCurrentTime().GetTime(), m_privateKey, tag);
	CBinaryData	bSrc;
	bSrc.AppendString(src);

	//	RC4
	CBinaryData	crypted;
	CCryptTools::CryptRC4(bSrc, crypted, m_scrambleKey);

	//	B64
	CString	b64;
	CBase64::Encode64bin(crypted, b64);

	return(b64);
}

/*!
	nonce`FbN

	\return FALSE:Fؕs, TRUE:FOK
*/
int CAuthenticateManager::CheckNonce(CString nonce, CString tag)
{
	//	B64
	CString		b64;
	CBinaryData	crypted;
	CBase64::Decode64bin(nonce, crypted);

	//	Í
	CBinaryData	bSrc;
	CCryptTools::CryptRC4(crypted, bSrc, m_scrambleKey);

	//	`FbN
	CString	src = bSrc.GetString();
	if(src.GetLength() < NONCE_MIN_LENGTH)
		return FALSE;

	//	L[擾
	CString	privateKey = src.Mid(TIME_LENGTH + 1, PRIVATE_KEY_LENGTH);
	if(privateKey != m_privateKey)
		return FALSE;

	//	^O擾
	CString	tagRet = src.Mid(NONCE_MIN_LENGTH);
	if(tagRet != tag)
		return FALSE;

	//	擾
	CString	strTime = src.Mid(0, TIME_LENGTH);
	__time64_t	time = _strtoi64(strTime, NULL, 16);
	if(time == 0)
		return FALSE;

	//	Ԍo߂`FbN
	if(CTime(time) + m_expireTime < CTime::GetCurrentTime())
		return FALSE;

	return TRUE;
}

