#include "StdAfx.h"
#include ".\bufferdsocket.h"
#include "threadskeleton.h"
#include <ws2tcpip.h>

#ifndef BUFFERD_SOCKET_BUF_SIZE
	#define	BUFFERD_SOCKET_BUF_SIZE	(64 * 1024)
#endif

CBufferdSocket::CBufferdSocket(void)
{
	//	̊m
	m_recvBuf.InitBuf(BUFFERD_SOCKET_BUF_SIZE);
	m_sendBuf.InitBuf(BUFFERD_SOCKET_BUF_SIZE);
}


CBufferdSocket::~CBufferdSocket(void)
{
	Close();
	m_recvBuf.Close();
	m_sendBuf.Close();
}

//////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////
/*!
	gpJn
*/
int CBufferdSocket::AttachSocket(SOCKET sock)
{
	//	I
	Close();

	//	obt@NA
	m_recvBuf.Clear();
	m_sendBuf.Clear();

	//	ϐݒ
	m_socket.AttachSocket(sock);
	ClearError();


	return(0);
}


/*!
	
*/
void CBufferdSocket::Close()
{
	if(m_socket.GetSocket() != INVALID_SOCKET)
	{
		//	
		m_socket.Close();
	}


	//	ǂݏo\̂ŁAobt@̓IuWFNg폜܂ŊJȂ
}

//////////////////////////////////////////////////////////////////////////////////
//	fC^[tF[X
//////////////////////////////////////////////////////////////////////////////////
/*!
	fCxgݒ
*/
void CBufferdSocket::SetBreakEvent(HANDLE breakEvent)
{
	m_socket.SetBreakEvent(breakEvent);
}


//////////////////////////////////////////////////////////////////////////////////
//	obt@ANZX
//////////////////////////////////////////////////////////////////////////////////
/*!
	M
*/
int CBufferdSocket::WriteBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_sendBuf.WriteBuf(data,len));
}


/*!
	M
*/
int CBufferdSocket::ReadBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_recvBuf.ReadBuf(data,len));
}


/*!
	M(obt@Ȃ)
*/
int CBufferdSocket::PeekBuf(char *data,int len)
{
	//	G[NA
	ClearError();

	return(m_recvBuf.PeekBuf(data,len));
}



//////////////////////////////////////////////////////////////////////////////////
//	ʐMXe[^X
//////////////////////////////////////////////////////////////////////////////////
/*!
	ؒfĂ邩擾
*/
int CBufferdSocket::IsDisconnect()
{
	//	G[NA
	ClearError();

	return m_socket.IsDisconnect();
};


/*!
	ؒfCxg擾
*/
HANDLE CBufferdSocket::GetDisconnectEvent()
{
	return m_socket.GetCloseEvent();
}


/*!
	obt@TCY擾
*/
int CBufferdSocket::GetSendRecvBufSize()
{
	return(BUFFERD_SOCKET_BUF_SIZE);
}

//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	obt@̃f[^𑗐M(ubLO)

	\return	-1:G[A0:MA>0:cf[^
*/
int CBufferdSocket::BlockingSend(int timeOut)
{
	//	f[^?
	if(m_sendBuf.GetInBuf() == 0)
		return(0);

	//	Mpobt@擾
	int		bufLen;
	char	*sendBuf = m_sendBuf.GetReadBuffer(&bufLen);

	//	M
	int sended = m_socket.BlockingSend(sendBuf, bufLen, timeOut);
	if(sended < 0)
	{
		switch(m_socket.GetLastError())
		{
		case COverlappedSocket::OVRS_ERROR_TIMEOUT:
			CloseError(CBS_ERROR_TIMEOUT, _T("BlockingSend"));
			break;

		case COverlappedSocket::OVRS_ERROR_CLOSE:
			CloseError(CBS_ERROR_CLOSE, _T("BlockingSend"));
			break;

		case COverlappedSocket::OVRS_ERROR_BREAK:
			CloseError(CBS_ERROR_BREAK, _T("BlockingSend"));
			break;

		case COverlappedSocket::OVRS_ERROR_OTHER:
		default:
			CloseError(CBS_ERROR_OTHER, _T("BlockingSend"));
			break;
		}
		return(-1);
	}

	//	Mf[^ʂݒ
	m_sendBuf.SetReadedLen(sended);
	return(m_sendBuf.GetInBuf());
}


/*!
	obt@փf[^M(ubLO)

	\return	-1:G[A0:MȂA>0:Mf[^
*/
int CBufferdSocket::BlockingRecv(int timeOut)
{
	//	obt@邩H
	if(m_recvBuf.GetFreeBuf() == 0)
		return(m_recvBuf.GetInBuf());	//	f[^Mς݂ȂI

	//	Mpobt@擾
	int		bufLen;
	char	*recvBuf = m_recvBuf.GetWriteBuffer(&bufLen);

	//	M
	int recved = m_socket.BlockingRecv(recvBuf, bufLen, timeOut);
	if(recved < 0)
	{
		switch(m_socket.GetLastError())
		{
		case COverlappedSocket::OVRS_ERROR_TIMEOUT:
			CloseError(CBS_ERROR_TIMEOUT, _T("BlockingRecv"));
			break;

		case COverlappedSocket::OVRS_ERROR_CLOSE:
			CloseError(CBS_ERROR_CLOSE, _T("BlockingRecv"));
			break;

		case COverlappedSocket::OVRS_ERROR_BREAK:
			CloseError(CBS_ERROR_BREAK, _T("BlockingRecv"));
			break;

		case COverlappedSocket::OVRS_ERROR_OTHER:
		default:
			CloseError(CBS_ERROR_OTHER, _T("BlockingRecv"));
			break;
		}
		return(-1);
	}

	//	Mf[^ʂݒ
	m_recvBuf.SetWritedLen(recved);
	return(m_recvBuf.GetInBuf());
}



//////////////////////////////////////////////////////////////////////////////////
//	ڑ
//////////////////////////////////////////////////////////////////////////////////
/*!
	̃AhX擾
*/
CIPAddress CBufferdSocket::GetAddres()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getsockname(m_socket.GetSocket(),(SOCKADDR*)&addr,&nSockAddrLen);
	return(addr.sin_addr);
}

/*!
	̃AhX擾
*/
CIPAddress CBufferdSocket::GetPeerAddres()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getpeername(m_socket.GetSocket(),(SOCKADDR*)&addr,&nSockAddrLen);
	return(addr.sin_addr);
}

/*!
	̃|[g擾	
*/
int CBufferdSocket::GetPort()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getsockname(m_socket.GetSocket(),(SOCKADDR*)&addr,&nSockAddrLen);
	return(ntohs(addr.sin_port));
}

/*!
	̃|[g擾
*/
int CBufferdSocket::GetPeerPort()
{
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int nSockAddrLen = sizeof(sockaddr_in);

	getpeername(m_socket.GetSocket(),(SOCKADDR*)&addr,&nSockAddrLen);
	return(ntohs(addr.sin_port));
}



//////////////////////////////////////////////////////////////////////////////////
//	G[
//////////////////////////////////////////////////////////////////////////////////
/*!
	G[ŕ
*/
void CBufferdSocket::CloseError(int code, CString debugInfo)
{
	TRACE("SocketError : %d:%s [%s] (SocketError : %d)\n", code, GetErrorString(code), debugInfo, WSAGetLastError());
	m_lastError = code;

	//	\Pbg
	if(m_socket.GetSocket() != INVALID_SOCKET)
		Close();
}

/*!
	G[𕶎Ŏ擾
*/
CString CBufferdSocket::GetLastErrorString()
{
	return(GetErrorString(GetLastError()));
}

/*!
	G[R[h當擾
*/
CString CBufferdSocket::GetErrorString(int errorCode)
{
	switch(errorCode)
	{
	case CBS_ERROR_TIMEOUT:
		return(_T("^CAEg܂"));

	case CBS_ERROR_CLOSE:
		return(_T("ڑؒf܂"));

	case CBS_ERROR_BREAK:
		return(_T("𒆒f܂"));

	case CBS_ERROR_OTHER:
		return(_T("lbg[NG[܂"));


	case CBS_NO_ERROR:
	default:
		return(_T("sȃG[܂"));
	}
}
