#pragma once
#include "AuthenticateManager.h"
#include "Workspace.h"
#include "Request.h"
#include "Alias.h"

enum AUTH_PARSE_STATUS
{
	AUTH_PARSE_STATUS_NONE	= 0,
	AUTH_PARSE_STATUS_OK	= 1,
	AUTH_PARSE_STATUS_ERROR	= -1,
};

/*!
	_CWFXgF؃NX
*/
class CDigestAuthenticate
{
public:
	/////////////////////////////////////////////////////////////////////////////////////////
	//	`FbN
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	Fؕ
	AUTH_PARSE_STATUS ParseAuthMethod(CAuthenticateManager *manager, CAlias &alias, CRequest &request);

	//!	F؃`FbN
	int CheckAuthUser(CAuthenticateManager *manager, CAlias &alias, CRequest &request);

	/////////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	F؃C擾
	CString GetBasicAuthOptionLine(CAlias &alias);

	//!	F؃C擾
	CString GetDigestAuthOptionLine(CAuthenticateManager *manager, CAlias &alias);

protected:
	/////////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////////
	//!	{F؂̏
	int ParseBasicAuth(CString authLine, CRequest &request);

	//!	Authorization IvV𕪉
	int ParseAuthOptionLine(CString optionLine, CRequest &request);

	//!	_CWFXgF؂̏ڍ׃`FbN
	int CheckDigestAuthRequest(CAuthenticateManager *manager, CAlias &alias, CRequest &request);

	//!	nbV`FbN
	int CheckDigestAuthResponse(CAlias &alias, CRequest &request, CString passwd, CString tag = _T(""));

	//!	[UEpX[hmF
	int GetUserPasswd(CAuthenticateManager *manager, CAlias &alias, CString userName, CString &passwd);

	//!	URÏvmF
	int CheckURIMatch(CString serverURI, CString clientURI);

	//!	realm擾
	CString GetRealm(CString realmSrc);
};
