#include "StdAfx.h"
#include ".\texttools.h"
#include <comutil.h>

#pragma comment(lib,"comsuppw.lib")

CString CTextTools::GetFormat(LPCTSTR lpszFormat, ...)
{
	va_list argList;
	CString	str;
	va_start(argList, lpszFormat);
	str.FormatV(lpszFormat,argList);
	va_end(argList);

	return str;
}


__int64 CTextTools::strtoi64(CString str,int base)
{
	char	*err;
	return _strtoi64(str,&err,base);
}



//////////////////////////////////////////////////////////////////////
// C؂o
//////////////////////////////////////////////////////////////////////
int CTextTools::GetLine(CString &str, CString &line)
{
	int index = str.Find("\r\n");

	if(index == -1)
	{
		if(str.IsEmpty())
			return(0);

		line = str;
		str.Empty();
		return(1);
	}
	
	//	؂o
	line = str.Left(index);

	//	폜
	str = str.Mid(index + 2);
	return(1);
}

//////////////////////////////////////////////////////////////////////
// g[N؂o
//////////////////////////////////////////////////////////////////////
int CTextTools::GetToken(CString &str, CString &token, CString div, int trim)
{
	//	ہH
	if(str.IsEmpty())
		return(0);

	//	div̒
	int tlen = div.GetLength();

	//	g[No
	int index = str.Find(div);
	if(index == -1)
	{
		token = str;
		if(trim)
			token.Trim();
		str.Empty();
		return(1);
	}
	
	//	؂o
	token = str.Left(index);
	if(trim)
		token.Trim();

	//	폜
	str = str.Mid(index + tlen);
	return(1);
}


/*!
	g[NSĐ؂o
*/
void CTextTools::GetAllToken(CString str, CStringArray &tokens, CString div, int trim)
{
	tokens.RemoveAll();

	CString token;
	while(GetToken(str, token, div, trim))
		tokens.Add(token);
}

/*!
	g[N̐؂o(_uR[e[Vɂ镶ɑΉ)
*/
int CTextTools::GetTokenDoubleQuotation(CString &str, CString &token, CString div, int trim)
{
	//	ہH
	if(str.IsEmpty())
		return(0);

	//	div̒
	int tlen = div.GetLength();

	//	g[No
	int	curPos = 0;
	while(1)
	{
		int divIndex = str.Find(div, curPos);
		if(divIndex == -1)
		{
			//	SĂg[N
			token = str;

			//	g
			if(trim)
				token.Trim();

			//	c폜
			str.Empty();
			return(1);	
		}

		//	_uR[e[V
		int dqIndex = str.Find(_T("\""), curPos);
		if(dqIndex != -1 && dqIndex < divIndex)	//	div_uR[e[VOɂ
		{
			//	
			dqIndex = str.Find(_T("\""), dqIndex + 1);
			if(dqIndex == -1)
			{
				//	SĂg[N
				token = str;

				//	g
				if(trim)
					token.Trim();

				//	c폜
				str.Empty();
				return(1);	
			}
			curPos = dqIndex + 1;
		}
		else
		{
			//	؂o
			token = str.Left(divIndex);
			if(trim)
				token.Trim();

			//	폜
			str = str.Mid(divIndex + tlen);
			return(1);
		}
	}
}

/*!
	g[NSĐ؂o(_uR[e[Vɂ镶ɑΉ)
*/
void CTextTools::GetAllTokenDoubleQuotation(CString str, CStringArray &tokens, CString div, int trim)
{
	tokens.RemoveAll();

	CString token;
	while(GetTokenDoubleQuotation(str, token, div, trim))
		tokens.Add(token);
}

/*!
	Õ_uR[e[V
*/
CString CTextTools::RemoveDoubleQuotation(CString str)
{
	//	ZH
	if(str.GetLength() < 2)
		return(str);

	//	_uR[e[V
	if(str.Left(1) == _T("\"") && str.Right(1) == _T("\""))
		str = str.Mid(1, str.GetLength() - 2);
	return(str);
}

//////////////////////////////////////////////////////////////
//	ChJ[hr
//////////////////////////////////////////////////////////////
/*!
	ChJ[hŔr

	\return TRUE->v
*/
int CTextTools::WildCompare(CString wild, CString str)
{
	//	O
	wild.MakeLower();
	str.MakeLower();

	return(StrMatch(wild, str));
}

/*!
	
*/
int CTextTools::StrMatch( const char *Ptn, const char *Str )
{
	switch( *Ptn )
	{
		case '\0':
			return (*Str=='\0');
		case '*':
			return StrMatch( Ptn+1, Str ) || (*Str!='\0') && StrMatch( Ptn, Str+1 );
		case '?':
			return (*Str!='\0') && StrMatch( Ptn+1, Str+1 );
		default:
			return ((unsigned char)*Ptn==(unsigned char)*Str) && StrMatch( Ptn+1, Str+1 );
	}
}


//////////////////////////////////////////////////////////////
//	z񏈗
//////////////////////////////////////////////////////////////
/*!
	z񂩂當
*/
int CTextTools::FindStrIndex(CStringArray &list, CString find, int noCase)
{
	for(int i=0;i<list.GetSize();i++)
	{
		if(noCase)
		{
			if(list[i].CompareNoCase(find) == 0)
				return(i);
		}
		else
		{
			if(list[i] == find)
				return(i);
		}
	}

	return(-1);
}

//////////////////////////////////////////////////////////////
//	ϊ
//////////////////////////////////////////////////////////////
/*!
	UnicodeAANSI
*/
CStringA CTextTools::WideStrToMultiStr(const wchar_t *str)
{
	CStringA	ret;
	ret = (char *)_bstr_t(str);

	return(ret);
}

/*!
	MBAUnicode
*/
CStringW CTextTools::MBStrToWideStr(const char *str)
{
	CStringW	ret;
	ret = str;

	return(ret);
}

/*!
	MBUTF8
*/
CStringA CTextTools::MBStrToUTF8Str(const char *str)
{
	//	UTF16֕ϊ
	CStringW			utf16(str);

	//	UTF8֕ϊ
	int mbLen = WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), NULL, 0, NULL, NULL);
	CStringA	utf8;
	WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), utf8.GetBuffer(mbLen + 1), mbLen, NULL, NULL);
	utf8.ReleaseBufferSetLength(mbLen);

	return(utf8);
}

/*!
	UTF8MB
*/
CStringA CTextTools::UTF8ToMBStr(const char *str)
{
	//	ϊ
	CStringW	utf16;
	int wbLen = MultiByteToWideChar(CP_UTF8, 0, str, (int)strlen(str), NULL, 0);
	MultiByteToWideChar(CP_UTF8, 0, str, (int)strlen(str), utf16.GetBuffer(wbLen), wbLen);
	utf16.ReleaseBufferSetLength(wbLen);

	return(CStringA(utf16));
}

/*!
	UnicodeUTF8
*/
CStringA CTextTools::WideStrToUTF8Str(const wchar_t *str)
{
	//	UTF16
	CStringW			utf16(str);

	//	UTF8֕ϊ
	int mbLen = WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), NULL, 0, NULL, NULL);
	CStringA	utf8;
	WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), utf8.GetBuffer(mbLen + 1), mbLen, NULL, NULL);
	utf8.ReleaseBufferSetLength(mbLen);

	return(utf8);
}

/*!
	UTF8
*/
CStringA CTextTools::StrToUTF8(CString str)
{
#ifdef _UNICODE
	return WideStrToUTF8Str(str);
#else
	return MBStrToUTF8Str(str);
#endif
}



///////////////////////////////////////////////////////////////////////////
//	̃GXP[v
///////////////////////////////////////////////////////////////////////////
/*!
	GXP[v̎s
*/
CString CTextEscape::Escape(CString src)
{
	CString	ret;

	int	curPos = 0;
	while(1)
	{
		int	findIndex;
		int itemIndex = MultiFind(curPos, findIndex, src, m_escape);

		if(itemIndex != -1)
		{
			//	؂o
			if(findIndex > curPos)
				ret += src.Mid(curPos, findIndex - curPos);

			//	u
			ret += m_escape[itemIndex].m_escape;
			curPos = findIndex + m_escape[itemIndex].m_token.GetLength();
		}
		else
		{
			if(ret.IsEmpty())
				return(src);
			return(ret + src.Mid(curPos));
		}
	}
}

/*!
	GXP[v̉
*/
CString CTextEscape::UnEscape(CString escaped)
{
	CString	ret;

	int	curPos = 0;
	while(1)
	{
		int	findIndex;
		int itemIndex = MultiFind(curPos, findIndex, escaped, m_unescape);

		if(itemIndex != -1)
		{
			//	؂o
			if(findIndex > curPos)
				ret += escaped.Mid(curPos, findIndex - curPos);

			//	u
			ret += m_unescape[itemIndex].m_escape;
			curPos = findIndex + m_unescape[itemIndex].m_token.GetLength();
		}
		else
		{
			if(ret.IsEmpty())
				return(escaped);
			return(ret + escaped.Mid(curPos));
		}
	}
}

/*!
	ǉ
*/
void CTextEscape::AddEscape(CString token, CString escape)
{
	m_escape.Add(CTextEscapeItem(token, escape));
	m_unescape.Add(CTextEscapeItem(escape, token));
}

/*!
	NA
*/
void CTextEscape::Clear()
{
	m_escape.RemoveAll();
	m_unescape.RemoveAll();
}


/*!
	ԍŏɌCfbNX擾
*/
int CTextEscape::MultiFind(int startIndex, int &findIndex, CString &src, CArray<CTextEscapeItem> &items)
{
	findIndex = src.GetLength() + 1;
	int	itemIndex = -1;
	for(int i=0;i<items.GetCount();i++)
	{
		int index = src.Find(items[i].m_token, startIndex);
		if(index != -1)
		{
			if(itemIndex == -1 || findIndex > index)
			{
				itemIndex = i;
				findIndex = index;
			}
		}
	}

	return(itemIndex);
}

