// Base64.cpp: CBase64 NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Base64.h"
#include "string.h"

static const unsigned char pr2six[256] =
{
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64,
    64,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64,
    64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
    64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64
};

static const char basis_64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

//////////////////////////////////////////////////////////////////////
// BinaryData <-> Hex
//////////////////////////////////////////////////////////////////////
/*!
	GR[h(Bin->Hex)
*/
void CBase64::EncodeHEXbin(CBinaryData &src, CString &dest)
{
	//	GR[h̒
	int	srcLen = src.GetSize();
	int encodedLen = srcLen * 2;

	//	obt@p
	unsigned char *srcPtr = (unsigned char *)src.GetPtr();
	TCHAR *destPtr = dest.GetBuffer(encodedLen);

	//	ϊ
	for(int i=0;i<srcLen;i++)
	{
		destPtr[0] = GetHexChar(*srcPtr >> 4);
		destPtr[1] = GetHexChar(*srcPtr & 0x0f);
		destPtr += 2;
		srcPtr++;
	}
	dest.ReleaseBufferSetLength(encodedLen);
}

/*!
	fR[h(Hex->Bin)

	\return 0:IA-1:G[
*/
int CBase64::DecodeHEXbin(CString src, CBinaryData &dest)
{
	//	`FbN
	int	srcLen = src.GetLength();
	if((srcLen % 2) != 0)	//	̓G[
		return(-1);

	//	fR[h̒
	int decodedLen = srcLen / 2;
	dest.ReSize(decodedLen);

	//	
	src.MakeLower();

	//	obt@p
	TCHAR *srcPtr = src.GetBuffer();
	unsigned char *destPtr = (unsigned char *)dest.GetPtr();

	//	fR[h
	for(int i=0;i<decodedLen; i++)
	{
		//	ϊĂ݂
		int	hVal = GetHexVal(srcPtr[0]);
		int	lVal = GetHexVal(srcPtr[1]);

		//	ϊG[
		if(hVal < 0 || lVal < 0)
			return(-1);

		*destPtr = (hVal<<4) + lVal;
		destPtr++;
		srcPtr += 2;
	}

	return(0);
}

/*!
	16iɕϊ
*/
_inline TCHAR CBase64::GetHexChar(int val)
{
	//	͈͊OH
	if(val <= 0)
		return(_T('0'));
	if(val >= 15)
		return(_T('f'));

	//	ϊ
	if(val <= 9)
		return(_T('0') + val);
	return(_T('a') + val - 10);
}

/*!
	16i𐔎(1ϊ)
	̂ݑΉ
*/
_inline int CBase64::GetHexVal(TCHAR hex)
{
	if(hex >= _T('0') && hex <= _T('9'))
		return(hex - _T('0'));
	if(hex >= _T('a') && hex <= _T('f'))
		return(hex - _T('a') + 10);

	//	͈͊O
	return(-1);
}



//////////////////////////////////////////////////////////////////////
// BinaryData <-> B64
//////////////////////////////////////////////////////////////////////
/*!
	GR[h
*/
void CBase64::Encode64bin(CBinaryData &src, CString &dest)
{
	char	*buf = dest.GetBuffer(GetEncodedLength(src.GetSize()));

	int len = _Encode(buf, (unsigned char *)src.GetPtr(), src.GetSize());
	dest.ReleaseBufferSetLength(len);
}

/*!
	fR[h
*/
void CBase64::Decode64bin(CString src, CBinaryData &dest)
{
	//	TCY擾
	int		len = GetDecodedLength(src.GetBuffer(0));
	dest.ReSize(len);

	len = _Decode((unsigned char *)dest.GetPtr(), src.GetBuffer(0));
	dest.ReSize(len);
}


//////////////////////////////////////////////////////////////////////
// String <-> B64
//////////////////////////////////////////////////////////////////////
/*!
	GR[hiText->B64j
*/
CString CBase64::Encode64(CString string)
{
	CString	ret;
	int		len = GetEncodedLength(string.GetLength());
	char	*buf = ret.GetBuffer(len);

	len = _Encode(buf,(unsigned char*)string.GetBuffer(0),string.GetLength());
	buf[len] = 0;
	ret.ReleaseBuffer();
	
	return(ret);
}

/*!
	GR[hiB64->Textj
*/
CString CBase64::Decode64(CString b64str)
{
	CString	ret;
	int		len =GetDecodedLength(b64str.GetBuffer(0));
	unsigned char	*buf = (unsigned char *)ret.GetBuffer(len);

	len = _Decode(buf,b64str.GetBuffer(0));
	buf[len] = 0;
	ret.ReleaseBuffer();
	
	return(ret);
}


//////////////////////////////////////////////////////////////////////
// GR[h
//////////////////////////////////////////////////////////////////////

//	GR[h̒擾
int CBase64::GetEncodedLength(int len)
{
    return ((len + 2) / 3 * 4) + 1;
}


//	GR[h
int CBase64::_Encode(char *encoded,const unsigned char *string, int len)
{
	int i;
	char *p;

	p = encoded;
	for (i = 0; i < len - 2; i += 3)
	{
		*p++ = basis_64[(string[i] >> 2) & 0x3F];
		*p++ = basis_64[((string[i] & 0x3) << 4) |
						((int) (string[i + 1] & 0xF0) >> 4)];
		*p++ = basis_64[((string[i + 1] & 0xF) << 2) |
						((int) (string[i + 2] & 0xC0) >> 6)];
		*p++ = basis_64[string[i + 2] & 0x3F];
	}

	if (i < len)
	{
		*p++ = basis_64[(string[i] >> 2) & 0x3F];
		if (i == (len - 1))
		{
			*p++ = basis_64[((string[i] & 0x3) << 4)];
			*p++ = '=';
		}
		else
		{
			*p++ = basis_64[((string[i] & 0x3) << 4) |
							((int) (string[i + 1] & 0xF0) >> 4)];
			*p++ = basis_64[((string[i + 1] & 0xF) << 2)];
		}
		*p++ = '=';
	}

	*p++ = '\0';
	return (int)(p - encoded);
}

//////////////////////////////////////////////////////////////////////
// fR[h
//////////////////////////////////////////////////////////////////////


//	fR[h̒擾
int CBase64::GetDecodedLength(const char *bufcoded)
{
    int nbytesdecoded;
    register const unsigned char *bufin;
    register int nprbytes;

    bufin = (const unsigned char *) bufcoded;
    while (pr2six[*(bufin++)] <= 63);

    nprbytes = (int)(bufin - (const unsigned char *) bufcoded) - 1;
    nbytesdecoded = ((nprbytes + 3) / 4) * 3;

    return nbytesdecoded + 1;
}

//	fR[h
int CBase64::_Decode(unsigned char *bufplain,const char *bufcoded)
{
	int nbytesdecoded;
	const unsigned char *bufin;
	unsigned char *bufout;
	int nprbytes;

	bufin = (const unsigned char *) bufcoded;
	while (pr2six[*(bufin++)] <= 63);
	nprbytes = (int)(bufin - (const unsigned char *) bufcoded) - 1;
	nbytesdecoded = ((nprbytes + 3) / 4) * 3;

	bufout = (unsigned char *) bufplain;
	bufin = (const unsigned char *) bufcoded;

	while (nprbytes > 4)
	{
		*(bufout++) =
			(unsigned char) (pr2six[*bufin] << 2 | pr2six[bufin[1]] >> 4);
		*(bufout++) =
			(unsigned char) (pr2six[bufin[1]] << 4 | pr2six[bufin[2]] >> 2);
		*(bufout++) =
			(unsigned char) (pr2six[bufin[2]] << 6 | pr2six[bufin[3]]);
		bufin += 4;
		nprbytes -= 4;
	}

	/* Note: (nprbytes == 1) would be an error, so just ingore that case */
	if (nprbytes > 1)
	{
		*(bufout++) =
			(unsigned char) (pr2six[*bufin] << 2 | pr2six[bufin[1]] >> 4);
	}
	if (nprbytes > 2)
	{
		*(bufout++) =
			(unsigned char) (pr2six[bufin[1]] << 4 | pr2six[bufin[2]] >> 2);
	}
	if (nprbytes > 3)
	{
		*(bufout++) =
			(unsigned char) (pr2six[bufin[2]] << 6 | pr2six[bufin[3]]);
	}

	nbytesdecoded -= (4 - nprbytes) & 3;
	return nbytesdecoded;
}
