#include "StdAfx.h"
#include "CGIProcessWrap.h"

CCGIProcessWrap::CCGIProcessWrap(void)
{
	m_cgiManager = NULL;
	m_cgiProcess = NULL;
}

CCGIProcessWrap::~CCGIProcessWrap(void)
{
	DeleteProcess();
}


///////////////////////////////////////////////////////////////////////////////
//	EI
///////////////////////////////////////////////////////////////////////////////
/*!
	(throw CCGIProcessException)
*/
void CCGIProcessWrap::CreateProcess(CString commandLine, int cgiInterfaceType, int cgiProcessType, CCGIManager *manager)
{
	m_cgiManager = manager;
	switch(manager->GetNewCGIProcess(commandLine, cgiInterfaceType, cgiProcessType, &m_cgiProcess))
	{
	case CGI_NEW_PROCESS_ERROR_NOERROR:
	default:
		break;

	case CGI_NEW_PROCESS_ERROR_OVER_PROCESS:
		throw CCGIProcessException(_T("ő哯sCGIvZX𒴂܂"));
	}
}

/*!
	pI
*/
void CCGIProcessWrap::DeleteProcess()
{
	if(m_cgiProcess != NULL)
		m_cgiProcess->CleanupCGIProcess();

	if(m_cgiManager != NULL)
		m_cgiManager->DeleteCGIProcess(m_cgiProcess);

	m_cgiManager = NULL;
	m_cgiProcess = NULL;
}

