#include "StdAfx.h"
#include "optionsresponse.h"

COptionsResponse::COptionsResponse(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias)
: CNormalResponse(server,context,request,alias)
{
}

COptionsResponse::~COptionsResponse(void)
{
}

/*
	X|X
*/
void COptionsResponse::CreateResponse()
{
	//	X|XR[h
	SetResponseCode(200);

	m_responseOptions.SetConfig("Dav","1");	
	m_responseOptions.SetConfig("MS-Author-Via","DAV");	//	ƓȂ炵
	m_responseOptions.SetConfig("Public","OPTIONS, GET, HEAD, DELETE, PUT, POST, COPY, MOVE, MKCOL, PROPFIND");	
	
	CString	allow = "OPTIONS";

	if(m_request.GetURIObject() == "*")
	{
		allow += ", GET, HEAD, DELETE, PUT, POST, COPY, MOVE, MKCOL, PROPFIND";	
	}
	else
	{
		if(m_alias.IsExist()==0)
			allow += ", GET, HEAD, POST";

		if(m_alias.GetPathOptions().GetConfig("EnableWrite",0))
		{
			if(m_alias.IsExist()==0)
				allow += ", DELETE, PUT, COPY, MKCOL, MOVE";
			else
				allow += ", DELETE, PUT, COPY, MOVE";
		}

		if(m_alias.GetPathOptions().GetConfig("EnableWebDAV",0))
		{
			if(m_alias.IsExist()==0)
				allow += ", PROPFIND";
		}
	}

	m_responseOptions.SetConfig("Allow",allow);	

}
