#include "StdAfx.h"
#include "PipeListener.h"

CPipeListener::CPipeListener(void)
{
	m_maxConnection = 0;
	m_waiting = 0;
	m_pipe = NULL;
	m_iocp = NULL;
}

CPipeListener::~CPipeListener(void)
{
}

//////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////
/*!
	pCvʐM̊Jn
*/
int CPipeListener::Init(CString pipeName, int maxConnection)
{
	//	ڑ
	m_maxConnection = maxConnection;

	//	ȌC
	if(pipeName.Left(4) != "\\\\.\\")
		m_pipeName = "\\\\.\\pipe\\" + pipeName;

	//	ZLeBݒ
	m_sa.BuildLocalSA();

	return(0);
}


/*!
	I
*/
void CPipeListener::Close()
{
	SAFE_CLOSE_HANDLE(m_pipe);
	m_waiting = 0;
}

//////////////////////////////////////////////////////////////////////////////////
//	ڑ
//////////////////////////////////////////////////////////////////////////////////
/*!
	pCv҂
*/
int CPipeListener::StartWaitPipe(HANDLE iocp, ULONG_PTR CompletionKey)
{
	m_iocp = iocp;
	m_completionKey = CompletionKey;

	//	łɑҋ@
	if(m_waiting)
		return(0);

	//	VKpCv
	if(CreateNewPipe())
		return(-1);

	//	҂󂯊Jn
	if(StartWaitConnect())
	{
		Close();
		return(-1);
	}

	m_waiting = 1;
	return(0);
}


/*!
	pCv擾
*/
HANDLE CPipeListener::GetNewPipe()
{
	DWORD	temp;
	if(!GetOverlappedResult(m_pipe, &m_connectOvrp, &temp, FALSE))
	{
		if(GetLastError() == ERROR_IO_INCOMPLETE)
			return(NULL);

		Close();
		return(NULL);	//	G[
	}

	m_waiting = 0;
	return(m_pipe);
}


//////////////////////////////////////////////////////////////////////////////////
//	ڑ
//////////////////////////////////////////////////////////////////////////////////
/*!
	J
*/
int CPipeListener::CreateNewPipe()
{
	//	H
	if(m_pipeName.IsEmpty())
		return(-1);

	// OtpCv̐
	m_pipe = ::CreateNamedPipe(m_pipeName, PIPE_ACCESS_DUPLEX | FILE_FLAG_OVERLAPPED,
									PIPE_TYPE_MESSAGE | PIPE_WAIT, m_maxConnection, 0, 0, 100, m_sa.GetSA());
	if(m_pipe == INVALID_HANDLE_VALUE)
		return(-1);

	//	IOCPLH
	if(m_iocp != NULL)
	{
		if(CreateIoCompletionPort(m_pipe, m_iocp, m_completionKey, 0) == NULL)
			return(-1);
	}

	return(0);
}

/*!
	ڑҋ@Jn
*/
int CPipeListener::StartWaitConnect()
{
	//	OVRP
	INIT_OVERLAPPED(m_connectOvrp, NULL);

	//	ҋ@Jn
	if(ConnectNamedPipe(m_pipe, &m_connectOvrp))
	{
		return(0);	//	I
	}

	//	̑̃G[H
	if(GetLastError() !=  ERROR_IO_PENDING)
		return(-1);

	return(0);
}

