/*
 * Decompiled with CFR 0.152.
 */
package roboguice.event.javaassist;

import java.lang.reflect.Method;

public class RuntimeSupport {
    public static String makeDescriptor(Method m) {
        Class[] params = m.getParameterTypes();
        return RuntimeSupport.makeDescriptor(params, m.getReturnType());
    }

    public static String makeDescriptor(Class[] params, Class retType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        for (int i = 0; i < params.length; ++i) {
            RuntimeSupport.makeDesc(sbuf, params[i]);
        }
        sbuf.append(')');
        RuntimeSupport.makeDesc(sbuf, retType);
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makeDesc(StringBuffer sbuf, Class type) {
        if (type.isArray()) {
            sbuf.append('[');
            RuntimeSupport.makeDesc(sbuf, type.getComponentType());
            return;
        } else if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                sbuf.append('V');
                return;
            } else if (type == Integer.TYPE) {
                sbuf.append('I');
                return;
            } else if (type == Byte.TYPE) {
                sbuf.append('B');
                return;
            } else if (type == Long.TYPE) {
                sbuf.append('J');
                return;
            } else if (type == Double.TYPE) {
                sbuf.append('D');
                return;
            } else if (type == Float.TYPE) {
                sbuf.append('F');
                return;
            } else if (type == Character.TYPE) {
                sbuf.append('C');
                return;
            } else if (type == Short.TYPE) {
                sbuf.append('S');
                return;
            } else {
                if (type != Boolean.TYPE) throw new RuntimeException("bad type: " + type.getName());
                sbuf.append('Z');
            }
            return;
        } else {
            sbuf.append('L').append(type.getName().replace('.', '/')).append(';');
        }
    }
}

