package jp.ac.titech.sharp4k.cuten;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ExpandableListView.OnChildClickListener;
import android.widget.ExpandableListView.OnGroupClickListener;
import android.widget.ImageButton;
import android.widget.SimpleExpandableListAdapter;

public class RecordActivity extends BaseMenuActivity {
	private ImageButton updateBtn, returnBtn;
	private ExpandableListView recordList;

	private SQLiteDatabase db;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.record);

		updateBtn = (ImageButton) findViewById(R.id.record_update_btn);
		returnBtn = (ImageButton) findViewById(R.id.record_return_btn);
		recordList = (ExpandableListView) findViewById(R.id.record_expandable_view);

		SQLHelper sqlhelper = new SQLHelper(this);
		db = sqlhelper.getReadableDatabase();

		setActionListener();
		getArrayAdapter();
	}

	public void onDestroy() {
		super.onDestroy();
		db.close();
	}

	private void setActionListener() {
		updateBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				// 更新処理
			}
		});

		returnBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});

		recordList.setOnGroupClickListener(new OnGroupClickListener() {
			@Override
			public boolean onGroupClick(ExpandableListView parent, View v,
					int groupPosition, long id) {
				if (parent.expandGroup(groupPosition)) {
					for (int i = 0; i < parent.getExpandableListAdapter()
							.getGroupCount(); i++) {
						if (i != groupPosition) {
							parent.collapseGroup(i);
						}
					}
				} else {
					parent.collapseGroup(groupPosition);
				}
				return true;
			}
		});

		recordList.setOnChildClickListener(new OnChildClickListener() {
			@Override
			public boolean onChildClick(ExpandableListView arg0, View arg1,
					int arg2, int arg3, long arg4) {
				// 詳細表示とか入れる？
				return false;
			}
		});
	}

	private void getArrayAdapter() {
		String lectureKey = "lecture";
		String taskKey = "task";
		String resultKey = "result";

		List<Lecture> lecList = Lecture.findSelectedAll(db);

		ArrayList<Map<String, String>> lecNameList = new ArrayList<Map<String, String>>();
		ArrayList<List<Map<String, String>>> taskList = new ArrayList<List<Map<String, String>>>();

		for (int i = 0; i < lecList.size(); i++) {
			Lecture lec = lecList.get(i);
			List<Task> tasks = lec.findTasks(db);

			Map<String, String> lecName = new HashMap<String, String>();
			lecName.put(lectureKey, lec.getName());
			lecNameList.add(lecName);
			{
				List<Map<String, String>> taskNameList = new ArrayList<Map<String, String>>();
				for (Task task : tasks) {
					Achievement a = Achievement.find(db, task);
					String result = a == null ? "" : a.getResultString();

					Map<String, String> taskName = new HashMap<String, String>();
					taskName.put(taskKey, task.getName());
					taskName.put(resultKey, result);
					taskNameList.add(taskName);
				}
				taskList.add(taskNameList);
			}
		}
		ExpandableListAdapter adapter = new SimpleExpandableListAdapter(this,
				lecNameList, android.R.layout.simple_expandable_list_item_1,
				new String[] { lectureKey }, new int[] { android.R.id.text1 },
				taskList, android.R.layout.simple_expandable_list_item_2,
				new String[] { taskKey, resultKey }, new int[] {
						android.R.id.text1, android.R.id.text2 });

		recordList.setAdapter(adapter);
	}
}
