package jp.ac.titech.sharp4k.cuten.test;

import jp.ac.titech.sharp4k.cuten.HttpAPIClient;
import jp.ac.titech.sharp4k.cuten.HttpResponseListener;
import jp.ac.titech.sharp4k.cuten.Token;
import jp.ac.titech.sharp4k.cuten.TokenAuthenticationActivity;

import com.google.inject.AbstractModule;

import android.widget.Button;
import android.widget.EditText;

public class AbnormalTokenAuthenticationActivityTest extends
		ActivityTestCaseWithRobo<TokenAuthenticationActivity> {
	private static class AbnormalHttpModule extends AbstractModule {
		@Override
		protected void configure() {
			bind(HttpAPIClient.class).to(AbormalHttpAPIClient.class);
		}
	}

	private static class AbormalHttpAPIClient extends NullHttpAPIClient {
		@Override
		public void getUsersProfile(String token, HttpResponseListener listener) {
			listener.preExec();
			listener.onUnauthorized();
			listener.postExec();
		}
	}

	private TokenAuthenticationActivity activity;
	private EditText tokenEdit;
	private Button authButton;

	public AbnormalTokenAuthenticationActivityTest() {
		super(TokenAuthenticationActivity.class, new AbnormalHttpModule());
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		activity = getActivity();
		tokenEdit = (EditText) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.token);
		authButton = (Button) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.authentication);
	}

	public void testKeepCurrentTokenOnFailure() throws Exception {
		assertNotNull(tokenEdit);
		assertNotNull(authButton);

		final String inputToken = "deadbeef";
		activity.runOnUiThread(new Runnable() {
			@Override
			public void run() {
				tokenEdit.setText(inputToken);
				authButton.performClick();
			}
		});
		waitUI();

		String token = Token.load(activity);
		assertFalse(token.equals(inputToken));
		assertEquals(dummyToken, token);
	}
}
