/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import roboguice.inject.SharedPreferencesName;

public class SharedPreferencesProvider
implements Provider<SharedPreferences> {
    protected static final String ROBOGUICE_1_DEFAULT_FILENAME = "default.xml";
    protected String preferencesName;
    @Inject
    protected Application application;

    public SharedPreferencesProvider() {
    }

    @Inject
    public SharedPreferencesProvider(PreferencesNameHolder preferencesNameHolder) {
        this.preferencesName = preferencesNameHolder.value;
    }

    public SharedPreferencesProvider(String preferencesName) {
        this.preferencesName = preferencesName;
    }

    public SharedPreferences get() {
        if (this.preferencesName != null) {
            return this.application.getSharedPreferences(this.preferencesName, 0);
        }
        if (new File("shared_prefs/default.xml").canRead()) {
            return this.application.getSharedPreferences(ROBOGUICE_1_DEFAULT_FILENAME, 0);
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)this.application);
    }

    public static class PreferencesNameHolder {
        @Inject(optional=true)
        @SharedPreferencesName
        protected String value;
    }
}

