package jp.ac.titech.sharp4k.cuten;

import org.apache.http.StatusLine;

public interface HttpResponseListener {
	// HTTP の結果に関係無く最初に呼ばれる
	public void preExec();

	// 通信に成功し 200 が返ってきたときに呼ばれる
	public void onSuccess(String body);

	// 通信には成功したが 401 が返ってきたときに呼ばれる
	public void onUnauthorized();

	// 通信には成功したがその他のステータスが返ってきたときに呼ばれる
	public void onHttpFailure(StatusLine status, String body);

	// 通信に失敗したときに呼ばれる
	public void onFailure(Exception exception);

	// HTTP の結果に関係無く最後に呼ばれる
	public void postExec();
}