package jp.ac.titech.sharp4k.cuten;

import org.apache.http.StatusLine;

import roboguice.activity.RoboActivity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.google.inject.Inject;

public class TokenAuthenticationActivity extends RoboActivity {
	private static final String TAG = TokenAuthenticationActivity.class
			.getSimpleName();

	Button loginPage, authentication;
	EditText token;
	ProgressDialog pDialog;
	@Inject
	private HttpAPIClient apiClient;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		// 起動時にキーボードを表示させない
		this.getWindow().setSoftInputMode(
				LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.tokenauth);

		// Viewの取得、ボタンのリスナーセット
		setLayout();
	}

	void setLayout() {
		loginPage = (Button) findViewById(R.id.loginPage);
		authentication = (Button) findViewById(R.id.authentication);
		token = (EditText) findViewById(R.id.token);
		// ブラウザ起動
		loginPage.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent();
				intent.setAction(Intent.ACTION_VIEW);
				intent.setData(Uri
						.parse("http://www16307ue.sakura.ne.jp:3001/"));
				startActivity(intent);
			}
		});
		// 認証開始
		authentication.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				checkAuthToken(token.getText().toString());
			}
		});
	}

	private void checkAuthToken(final String authToken) {
		showProgressDialog("認証中・・・");
		apiClient.getUsersProfile(authToken, new SimpleHttpResponseListener() {
			@Override
			public void preExec() {
				dismissProgressDialog();
			}

			@Override
			public void onSuccess(String body) {
				// 認証成功
				// トークンをローカルファイルとして保存
				Token.save(authToken, TokenAuthenticationActivity.this);
				showSuccessDialog("認証に成功しました！");
			}

			@Override
			public void onUnauthorized() {
				// 認証に失敗
				showAlertDialog("認証に失敗しました。トークンが正しいか確認してください。");
			}

			@Override
			public void onFailure(Exception e) {
				// ネットワークエラー
				Log.e(TAG, "getUsersProfile:");
				e.printStackTrace();
				showAlertDialog("ネットワークエラーが発生しました。もう一度試してください。");
			}

			@Override
			public void onHttpFailure(StatusLine status, String body) {
				// ネットワークエラー
				showAlertDialog("ネットワークエラーが発生しました。もう一度試してください。");
			}
		});
	}

	// プログレスダイアログ(サーバとの通信中に表示)
	public void showProgressDialog(String message) {
		pDialog = new ProgressDialog(this);
		pDialog.setTitle("通信中");
		pDialog.setMessage(message);
		pDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		pDialog.setCancelable(false);
		pDialog.show();
	}

	// プログレスダイアログを非表示にする
	public void dismissProgressDialog() {
		pDialog.dismiss();
	}

	// 警告ダイアログ
	public void showAlertDialog(String message) {
		new AlertDialog.Builder(this).setTitle("警告").setMessage(message)
				.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
					}
				}).setCancelable(false).show();
	}

	// 成功ダイアログ okボタンを押すと元のアクティビティに遷移する
	public void showSuccessDialog(String message) {
		new AlertDialog.Builder(this).setTitle("認証成功").setMessage(message)
				.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						finish();
					}
				}).setCancelable(false).show();
	}

	// バックボタンを無効化する
	@Override
	public boolean dispatchKeyEvent(KeyEvent e) {
		if (e.getAction() == KeyEvent.ACTION_DOWN
				&& e.getKeyCode() == KeyEvent.KEYCODE_BACK
				&& !Token.isExist(this)) {
			Toast.makeText(this, "トークンが登録されていません", Toast.LENGTH_SHORT).show();
			return true;
		}
		return super.dispatchKeyEvent(e);
	}
}
