require 'test_helper'

class TeachersControllerTest < ActionController::TestCase
  setup do
    @teacher = FactoryGirl.create :teacher
  end

  test "should NOT get index" do
    assert_no_routes do
      get :index
    end
  end

  test "should NOT get new" do
    assert_no_routes do
      get :new
    end
  end

  test "should NOT create teacher" do
    assert_no_routes do
      post :create, teacher: { name: @teacher.name }
    end
  end

  test "should show teacher" do
    get :show, id: @teacher
    assert_response :success
  end

  test "should NOT update teacher" do
    assert_no_routes do
      put :update, id: @teacher, teacher: { name: @teacher.name }
    end
  end

  test "should NOT destroy teacher" do
    assert_no_routes do
      delete :destroy, id: @teacher
    end
  end
end
