package jp.ac.titech.sharp4k.cuten;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import android.net.ParseException;
import android.os.AsyncTask;
import android.util.Log;

public class DownloadTask extends AsyncTask<String, Void, String> {
	JsonParseTestActivity main;

	// コンストラクタ　呼び出しもとの関数をこちらのクラスから呼び出したいので、Activityをもらう
	public DownloadTask(JsonParseTestActivity main) {
		this.main = main;
	}

	@Override
	// UIスレッドと非同期で処理されるメソッド
	// サーバからJSONデータをとってくる
	protected String doInBackground(String... uri) {
		HttpClient httpClient = new DefaultHttpClient();
		HttpUriRequest httpRequest = new HttpGet(uri[0]);
		HttpResponse httpResponse = null;
		try {
			httpResponse = httpClient.execute(httpRequest);
		} catch (ClientProtocolException e) {
			Log.e("exception", "ClientProtocolException");
			e.printStackTrace();
		} catch (IOException e) {
			Log.e("exception", "IOException");
			e.printStackTrace();
		}
		String json = null;
		if (httpResponse != null
				&& httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
			HttpEntity httpEntity = httpResponse.getEntity();
			try {
				json = EntityUtils.toString(httpEntity);
			} catch (ParseException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					httpEntity.consumeContent();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		httpClient.getConnectionManager().shutdown();
		return json;
	}

	@Override
	// doInBackground()の終了後UIスレッドによって処理されるメソッド
	protected void onPostExecute(String result) {
		main.jsonParse(result);
		main.classifyData();
		main.configListView();
		main.changeMode(0);
	}

}
