package jp.ac.titech.sharp4k.cuten;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import android.app.Activity;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;

public class JsonParseTestActivity extends Activity {
	ArrayList<Lecture> lectures, haveLecture, newLecture;
	ArrayList<Teacher> teachers, haveTeacher, newTeacher;
	TextView tv;
	ListView lectureList;
	ArrayAdapter<String> haveAdapter, newAdapter;
	Button add, delete, ok, move;
	String haveLectureNames[], newLectureNames[];
	SQLHelper helper;
	SQLiteDatabase db;
	Cursor cursor;
	int mode;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.downloadown);

		// Viewの取得、ボタンのリスナーセット
		setLayout();
		// SQLiteのテーブルを作成or開く
		openTable();
		// selected_lecturesから、既に選択されている講義のidをとってくる
		getData();
		// サーバからJSONデータをとってくる
		DownloadTask task = new DownloadTask(this);
		//task.execute("http://131.112.197.37:3000/lectures");
		task.execute("http://192.168.11.172:3000/lectures");
	}

	void setLayout() {
		tv = (TextView) findViewById(R.id.textView);
		lectureList = (ListView) findViewById(R.id.lectureList);
		add = (Button) findViewById(R.id.add);
		add.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				changeMode(0);
			}
		});
		delete = (Button) findViewById(R.id.delete);
		delete.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				changeMode(1);
			}
		});
		ok = (Button) findViewById(R.id.ok);
		move = (Button) findViewById(R.id.move);
		move.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});
	}

	void openTable() {
		helper = new SQLHelper(this);
		db = helper.getWritableDatabase();
	}

	void getData() {
		cursor = db.query("selected_lectures", new String[] { "id" }, null,
				null, null, null, "id");
	}

	// とりあえず全データをlecturesとteachersにぶっこむ
	void jsonParse(String data) {
		try {
			JSONArray root = new JSONArray(data);
			lectures = new ArrayList<Lecture>();
			teachers = new ArrayList<Teacher>();
			for (int i = 0; i < root.length(); i++) {
				JSONObject lecture = root.getJSONObject(i);
				JSONObject teacher = lecture.getJSONObject("teacher");
				JSONArray taskIds = lecture.getJSONArray("task_ids");
				List<Integer> taskIdsList = new ArrayList<Integer>();
				for (int j = 0; j < taskIds.length(); j++) {
					taskIdsList.add(taskIds.getInt(j));
				}
				teachers.add(new Teacher(teacher.getInt("id"), teacher
						.getString("name")));
				lectures.add(new Lecture(lecture.getInt("id"), lecture
						.getString("name"), teachers.get(teachers.size() - 1),
						taskIdsList));
				storeData("lectures", lectures.get(lectures.size() - 1));
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
	}

	// selected_lecturesの情報をもとに、未登録と登録済みの講義を分別する
	void classifyData() {
		haveLecture = new ArrayList<Lecture>();
		haveTeacher = new ArrayList<Teacher>();
		newLecture = new ArrayList<Lecture>();
		newTeacher = new ArrayList<Teacher>();
		int count = cursor.getCount(), i, j;
		for (i = 0; i < lectures.size(); i++) {
			cursor.moveToFirst();
			for (j = 0; j < count; j++) {
				if (lectures.get(i).getId() == cursor.getInt(0)) {
					haveLecture.add(lectures.get(i));
					break;
				}
				cursor.moveToNext();
			}
			if (j == count) {
				newLecture.add(lectures.get(i));
			}
		}
	}

	// ListViewのAdapterを作りセットする
	void configListView() {
		haveLectureNames = new String[haveLecture.size()];
		newLectureNames = new String[newLecture.size()];
		for (int i = 0; i < haveLecture.size(); i++) {
			haveLectureNames[i] = haveLecture.get(i).getName();
		}
		for (int i = 0; i < newLecture.size(); i++) {
			newLectureNames[i] = newLecture.get(i).getName();
		}
		haveAdapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_list_item_multiple_choice,
				haveLectureNames);
		newAdapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_list_item_multiple_choice,
				newLectureNames);
		lectureList.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
	}

	// 指定されたテーブルに情報をinsertする
	void storeData(String table, Lecture l) {
		ContentValues values = new ContentValues();
		if (table.equals("lectures")) {
			values.put("id", l.getId());
			values.put("name", l.getName());
			values.put("teacher_id", l.getTeacher().getId());
		} else if (table.equals("selected_lectures")) {
			values.put("id", l.getId());
		}
		db.insert(table, null, values);
	}

	// selected_lectureに登録されている講義を未登録に戻す
	void deleteData(Lecture l) {
		db.delete("selected_lectures", "id = ?",
				new String[] { Integer.toString(l.getId()) });
	}
	
	void changeMode(int mode) {
		// 未登録講義一覧モード
		if(mode == 0) {
			lectureList.setAdapter(newAdapter);
			tv.setText("登録したい講義を選択し、下の登録ボタンを押してください");
			ok.setText("登録");
			ok.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					for (int i = 0; i < newLecture.size(); i++)
						if (lectureList.isItemChecked(i))
							storeData("selected_lectures", newLecture.get(i));
					getData();
					classifyData();
					configListView();
					lectureList.setAdapter(newAdapter);
				}
			});
		}
		// 登録済講義一覧モード
		else if(mode == 1) {
			lectureList.setAdapter(haveAdapter);
			tv.setText("削除したい講義を選択し、下の削除ボタンを押してください");
			ok.setText("削除");
			ok.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					for (int i = 0; i < haveLecture.size(); i++)
						if (lectureList.isItemChecked(i))
							deleteData(haveLecture.get(i));
						getData();
						classifyData();
						configListView();
						lectureList.setAdapter(haveAdapter);
				}
			});
		}
	}
	
}
