package jp.ac.titech.sharp4k.cuten;

import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;

public class LectureActivity extends Activity implements OnClickListener {
	private static final String TAG = "LectureActivity";
	private static final int TASK_REQUEST_CODE = 9;
	private String[] taskNames;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.lecture);
		// データベース読み取りor作成
		DatabaseHelper h = new DatabaseHelper(this);
		final SQLiteDatabase db = h.getReadableDatabase();
		// LECTURE_KEYを受け取って、データベースから講義情報を検索
		Integer lec = getIntent().getIntExtra(
				LectureFolderActivity.LECTURE_KEY, 1);
		Lecture lecture = Lecture.find(db, lec);

		// ヘッダ
		ImageView img = (ImageView) findViewById(R.id.imageButtonLecture);
		// アイコン
		// img.setImageResource(R.drawable.);
		// img.setOnClickListener();

		// スクロール
		LinearLayout scr = (LinearLayout) findViewById(R.id.linearViewLecture);
		// ボタンに講義情報表示
		Button btn = (Button) findViewById(R.id.buttonLecture);
		btn.setText(getLectureString(lecture));
		// データベースからタスクを情報取得して、ボタンに表示
		{
			// 結果をlistに格納
			List<Task> tasks = lecture.findTasks(db);

			for (int i = 0; i < tasks.size(); i++) {
				Task tsk = tasks.get(i);

				// ボタン作成
				Button b = new Button(this);
				// 背景
				// b.setBackgroundDrawable(d);
				// 左にアイコン Drawable
				// d=getResources().getDrawable(R.drawable.nekonote);
				// d.setBounds(0, 0, d.getIntrinsicWidth()/2,
				// d.getIntrinsicHeight()/2); b.setCompoundDrawables(d,
				// null,null, null);

				b.setHeight(128);
				b.setOnClickListener(this);
				scr.addView(b);
				b.setId(tsk.getId());
				b.setText(getTaskString(i, tsk));
			}
		}
		db.close();
	}

	private String getLectureString(Lecture lec) {
		String str = lec.getName() + "(";
		str += lec.getTeacher().getName() + ")";
		return str;
	}

	private String getTaskString(int no, Task task) {
		Integer n = no;
		return "" + n.toString() + ". " + task.getName();
	}

	public void onClick(View v) {
		Integer id = v.getId();
		// データベース読み取りor作成
		DatabaseHelper h = new DatabaseHelper(this);
		final SQLiteDatabase db = h.getReadableDatabase();
		// DBから名前取得
		String[] arg = { id.toString() };
		Cursor c = db
				.rawQuery(
						"SELECT jars.name,tasks.name from tasks,jars WHERE tasks.id=? AND tasks.id=jars.task_id;",
						arg);
		if (c.getCount() == 0) {
			Log.d(TAG, "jar id = " + id.toString() + " : not found");
			return;
		}
		c.moveToFirst();
		String qualName = c.getString(0);
		String taskName = c.getString(1);
		c.close();
		db.close();
		//
		String jarName = id.toString() + ".jar";
		Intent intent = new Intent(this, TaskActivity.class);
		intent.putExtra(TaskActivity.TASK_NAME_KEY, taskName);
		intent.putExtra(TaskActivity.JAR_NAME_KEY, jarName);
		intent.putExtra(TaskActivity.QUAL_NAME_KEY, qualName);
		Log.d(TAG, "startActivity: " + jarName + ":" + qualName);
		startActivityForResult(intent, TASK_REQUEST_CODE);
	}

	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent intent) {
		super.onActivityResult(requestCode, resultCode, intent);
		switch (requestCode) {
		case TASK_REQUEST_CODE:
			onTaskFinish(resultCode, intent);
			break;
		default:
			Log.w(TAG, "Unknown requestCode: " + requestCode);
			break;
		}
	}

	private void onTaskFinish(int resultCode, Intent intent) {
		Log.d(TAG, "onTaskFinish: resultCode = " + resultCode);
		if (resultCode == RESULT_OK) {
			int result = intent.getIntExtra(TaskActivity.RESULT_KEY, -1);
			if (result < 0) {
				Toast.makeText(this, "閉じるボタンで戻って下さい＞＜", Toast.LENGTH_LONG)
						.show();
			} else {
				Toast.makeText(this, "結果は" + result + "だよっ！", Toast.LENGTH_LONG)
						.show();
			}
		}
	}

	class DatabaseHelper extends SQLiteOpenHelper {
		public DatabaseHelper(Context context) {
			super(context, "cuten", null, 1);
		}

		@Override
		public void onCreate(SQLiteDatabase db) {
			db.execSQL("CREATE TABLE \"jars\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"revision\" integer, \"task_id\" integer, \"created_at\" datetime NOT NULL, \"updated_at\" datetime NOT NULL);");
			db.execSQL("CREATE TABLE \"lectures\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"teacher_id\" integer, \"created_at\" datetime NOT NULL, \"updated_at\" datetime NOT NULL);");
			db.execSQL("CREATE TABLE \"schema_migrations\" (\"version\" varchar(255) NOT NULL);");
			db.execSQL("CREATE TABLE \"tasks\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"lecture_id\" integer, \"created_at\" datetime NOT NULL, \"updated_at\" datetime NOT NULL);");
			db.execSQL("CREATE TABLE \"teachers\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"created_at\" datetime NOT NULL, \"updated_at\" datetime NOT NULL);");
			db.execSQL("CREATE INDEX \"index_jars_on_task_id\" ON \"jars\" (\"task_id\");");
			db.execSQL("CREATE INDEX \"index_lectures_on_teacher_id\" ON \"lectures\" (\"teacher_id\");");
			db.execSQL("CREATE INDEX \"index_tasks_on_lecture_id\" ON \"tasks\" (\"lecture_id\");");
			// add lecture
			String insertLec = "INSERT INTO \"lectures\" (\"name\" , \"teacher_id\" , \"created_at\", \"updated_at\") VALUES (?,?,datetime() ,datetime() );";
			// name,teacher_id
			Object[][] lecData = { { "lec1", 1 }, { "lec2", 2 }, { "lec3", 3 }, };
			for (Object[] lec : lecData) {
				db.execSQL(insertLec, lec);
			}
			// add tasks
			String insertTask = "INSERT INTO \"tasks\" (\"name\" , \"lecture_id\" , \"created_at\" , \"updated_at\" ) VALUES (?,?,datetime(),datetime());";
			// name,lecture_id
			Object[][] tskData = { { "task1-1", 1 }, { "task1-2", 1 },
					{ "task2-1", 2 }, { "task2-2", 2 }, { "task3", 3 }, };
			for (Object[] tsk : tskData) {
				db.execSQL(insertTask, tsk);
			}
			//
			String insertTeacher = "INSERT INTO \"teachers\" (\"name\" , \"created_at\", \"updated_at\") VALUES (?,datetime() ,datetime() );";
			// name,teacher_id
			Object[][] teacherData = { { "teacher1" }, { "teacher2" },
					{ "teacher3" }, };
			for (Object[] teacher : teacherData) {
				db.execSQL(insertTeacher, teacher);
			}
			// add jars
			String insertJar = "INSERT INTO \"jars\" (\"name\" ,\"revision\",\"task_id\",\"created_at\", \"updated_at\") VALUES (?,0,?,datetime() ,datetime() );";
			// name,teacher_id
			Object[][] jarData = { { "a", 0 }, { "a", 1 }, { "a", 2 },
					{ "jp.ac.titech.sharp4k.cuten.sampletask.Hello3Task", 3 },
					{ "jp.ac.titech.sharp4k.cuten.sampletask.Hello3Task", 4 }, };
			for (Object[] jar : jarData) {
				db.execSQL(insertJar, jar);
			}
		}

		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		}
	}
}
