package jp.ac.titech.sharp4k.cuten;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class SQLHelper extends SQLiteOpenHelper {

	final static private int DB_VERSION = 1;

	public SQLHelper(Context context) {
		super(context, "cuten.db", null, DB_VERSION);

	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE \"teachers\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255));");
		db.execSQL("CREATE TABLE \"lectures\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"teacher_id\" integer);");
		db.execSQL("CREATE TABLE \"tasks\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"lecture_id\" integer);");
		db.execSQL("CREATE TABLE \"jars\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"revision\" integer, \"task_id\" integer);");
		db.execSQL("CREATE TABLE \"selected_lectures\" (\"id\" INTEGER PRIMARY KEY NOT NULL);");
		db.execSQL("CREATE INDEX \"index_lectures_on_teacher_id\" ON \"lectures\" (\"teacher_id\");");
		db.execSQL("CREATE INDEX \"index_tasks_on_lecture_id\" ON \"tasks\" (\"lecture_id\");");
		db.execSQL("CREATE INDEX \"index_jars_on_task_id\" ON \"jars\" (\"task_id\");");

		for (int i = 0; i < 10; i++) {
			ContentValues row = new ContentValues();
			row.put("id", i);
			row.put("name", "かわいい先生第" + i);
			row.put("teacher_id", 0);
			db.insert("lectures", null, row);
		}

		for (int i = 0; i < 6; i++) {
			ContentValues row = new ContentValues();
			row.put("id", i);
			row.put("name", "task" + (i / 2) + "-" + (i % 2));
			row.put("lecture_id", i / 2);
			db.insert("tasks", null, row);
		}

		for (int i : new int[] { 0, 2, 4, 6, 7 }) {
			ContentValues row = new ContentValues();
			row.put("id", i);
			db.insert("selected_lectures", null, row);
		}

		{
			ContentValues row = new ContentValues();
			row.put("id", 0);
			row.put("name", "にゃんこ先生");
			db.insert("teachers", null, row);
		}
	}

	@Override
	public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {

	}

}
