/*
 * Decompiled with CFR 0.152.
 */
package roboguice.event;

import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import roboguice.event.EventManager;
import roboguice.event.EventThread;
import roboguice.event.Observes;
import roboguice.event.eventListener.ObserverMethodListener;
import roboguice.event.eventListener.factory.EventListenerThreadingDecorator;

public class ObservesTypeListener
implements TypeListener {
    protected Provider<EventManager> eventManagerProvider;
    protected EventListenerThreadingDecorator observerThreadingDecorator;

    public ObservesTypeListener(Provider<EventManager> eventManagerProvider, EventListenerThreadingDecorator observerThreadingDecorator) {
        this.eventManagerProvider = eventManagerProvider;
        this.observerThreadingDecorator = observerThreadingDecorator;
    }

    public <I> void hear(TypeLiteral<I> iTypeLiteral, TypeEncounter<I> iTypeEncounter) {
        for (Class c = iTypeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                this.findContextObserver(method, iTypeEncounter);
            }
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                for (Method method : ((Class)genericDeclaration).getDeclaredMethods()) {
                    this.findContextObserver(method, iTypeEncounter);
                }
            }
        }
    }

    protected <I> void findContextObserver(Method method, TypeEncounter<I> iTypeEncounter) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotationArray = parameterAnnotations[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : annotationArray) {
                if (!annotation.annotationType().equals(Observes.class)) continue;
                this.registerContextObserver(iTypeEncounter, method, parameterType, ((Observes)annotation).value());
            }
        }
    }

    protected <I, T> void registerContextObserver(TypeEncounter<I> iTypeEncounter, Method method, Class<T> parameterType, EventThread threadType) {
        this.checkMethodParameters(method);
        iTypeEncounter.register(new ContextObserverMethodInjector(this.eventManagerProvider, this.observerThreadingDecorator, method, parameterType, threadType));
    }

    protected void checkMethodParameters(Method method) {
        if (method.getParameterTypes().length > 1) {
            throw new RuntimeException("Annotation @Observes must only annotate one parameter, which must be the only parameter in the listener method.");
        }
    }

    public static class ContextObserverMethodInjector<I, T>
    implements InjectionListener<I> {
        protected EventListenerThreadingDecorator observerThreadingDecorator;
        protected Provider<EventManager> eventManagerProvider;
        protected Method method;
        protected Class<T> event;
        protected EventThread threadType;

        public ContextObserverMethodInjector(Provider<EventManager> eventManagerProvider, EventListenerThreadingDecorator observerThreadingDecorator, Method method, Class<T> event, EventThread threadType) {
            this.observerThreadingDecorator = observerThreadingDecorator;
            this.eventManagerProvider = eventManagerProvider;
            this.method = method;
            this.event = event;
            this.threadType = threadType;
        }

        public void afterInjection(I i) {
            ((EventManager)this.eventManagerProvider.get()).registerObserver(this.event, this.observerThreadingDecorator.decorate(this.threadType, new ObserverMethodListener(i, this.method)));
        }
    }
}

