require 'pathname'
require 'fileutils'
$LOAD_PATH.unshift File.expand_path('../../tools/lib', __FILE__)
require 'cuten_app'

class Rake::CircuitTask < Rake::TaskLib
  def initialize(name)
    @name = name
  end

  def define
    app_name = "Circuit-#{@name}"
    project = Android::Project.new app_name
    sdk = Android::Sdk.new ENV['ANDROID_HOME'], project

    namespace @name do
      task = Rake::CutenAppTask.new sdk
      task.before_resources do
        setup_resources project
      end
      task.define_all
    end
  end

  def setup_resources(project)
    question_path = Pathname.new('.').join('drawable', 'question.png')
    array_path = Pathname.new('.').join('values', 'array.xml')
    strings_path = Pathname.new('.').join('values', 'strings.xml')

    res_dir = Pathname.new('res-tasks').join("res-#{@name}")
    [question_path, array_path, strings_path].each do |path|
      FileUtils.cp res_dir.join(path).to_s, project.res_dir.join(path).to_s
    end
  end
end
