# coding: utf-8
# This file should contain all the record creation needed to seed the database with its default values.
# The data can then be loaded with the rake db:seed (or created alongside the db with db:setup).
#
# Examples:
#
#   cities = City.create([{ name: 'Chicago' }, { name: 'Copenhagen' }])
#   Mayor.create(name: 'Emanuel', city: cities.first)

if Rails.env.development?
  # Insert dummy data
  [Apk, Task, Lecture, Teacher].each(&:delete_all)

  nyanko = Teacher.create :name => "にゃんこ先生"

  lectures =
    10.times.map do |i|
      lec = Lecture.create :name => "かわいい先生学第#{i}"
      lec.teacher = nyanko
      lec.save!
      lec
    end

  hello_apk = File.new '../Hello3Task/bin/Hello3Task-debug.apk'
  6.times do |i|
    task = Task.create :name => "きゅーと課題#{i/2} その#{i%2}"
    task.lecture = lectures[i/2]
    task.save!

    apk = Apk.create :name => 'jp.ac.titech.sharp4k.cuten.sampletask.Hello3Task', :revision => 0
    apk.task = task
    apk.save!
    apk.store_file hello_apk
  end

  # One apk has newer revision
  task = Task.first
  apk = Apk.create :name => task.apk.name, :revision => (task.apk.revision+1)
  apk.task = task
  apk.save!
  apk.store_file hello_apk
end
