package jp.ac.titech.sharp4k.cuten.sampletask;

import java.util.Date;

import jp.ac.titech.sharp4k.cuten.BaseApp;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class Hello3Task extends BaseApp {
	private static final String TAG = Hello3Task.class.getSimpleName();

	private Context ctx;
	private boolean yetAnother;
	private TextView orientationView;

	@Override
	protected View createView(Context ctx, Resources res) {
		this.ctx = ctx;
		yetAnother = false;

		LinearLayout root = new LinearLayout(ctx);
		root.setOrientation(LinearLayout.VERTICAL);

		TextView tv = new TextView(ctx);
		String message = res.getString(R.string.hello);
		tv.setText(message);
		root.addView(tv);

		ImageView imageView = new ImageView(ctx);
		imageView.setImageDrawable(res.getDrawable(R.drawable.sharp4k));
		imageView.setBackgroundDrawable(res.getDrawable(R.drawable.sharp4k_bg));
		root.addView(imageView);

		Button button = new Button(ctx);
		button.setText("Yet another close button");
		button.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				yetAnother = true;
				close();
			}
		});
		root.addView(button);

		orientationView = new TextView(ctx);
		updateOrientation(res.getConfiguration());
		root.addView(orientationView);

		int[] results = { new Date().getSeconds(), 0, 0 };
		sendResult(results);
		return root;
	}

	@Override
	protected void onClose() {
		if (yetAnother) {
			Toast.makeText(ctx, "You clicked yet another version!",
					Toast.LENGTH_SHORT).show();
		}
		super.onClose();
	}

	@Override
	protected void onConfigurationChanged(Configuration newConfig) {
		updateOrientation(newConfig);
	}

	private void updateOrientation(Configuration config) {
		String text = "???";
		switch (config.orientation) {
		case Configuration.ORIENTATION_LANDSCAPE:
			text = "LANDSCAPE";
			break;
		case Configuration.ORIENTATION_PORTRAIT:
			text = "PORTRAIT";
			break;
		case Configuration.ORIENTATION_SQUARE:
			text = "SQUARE";
			break;
		case Configuration.ORIENTATION_UNDEFINED:
			text = "UNDEFINED";
			break;
		}
		orientationView.setText(text);
	}

	@Override
	protected void onPause() {
		Log.d(TAG, "onPause");
	}

	@Override
	protected void onResume() {
		Log.d(TAG, "onResume");
	}
}
