package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;

import java.util.Arrays;
import java.util.Comparator;

import android.opengl.Matrix;

public abstract class PolychoronObj {
	protected float[] vertex;
	protected PolychoronVertex[] edges;
	protected PolychoronVertex[] vertexList;

	public PolychoronObj() {
		vertex = null;
	}

	public PolychoronObj(float[] v) {
		vertex = v;
		init();
	}

	void init() {
		vertexList = new PolychoronVertex[vertex.length / 4];
		float[] initMat=new float[16];
		for (int i = 0; i < vertex.length / 4; i++) {
			vertexList[i] = new PolychoronVertex();
			float[] v = { vertex[i * 4], vertex[i * 4 + 1], vertex[i * 4 + 2],
					vertex[i * 4 + 3] };
			vertexList[i].v4 = v.clone();
			PolychoronVertex.rotateUZ(initMat,0.5f);
			vertexList[i].setConvert1(initMat);
			vertexList[i].convert1();
		}
	}

	public int getEdgeNum() {
		return edges.length;
	}
	public int getVertexNum() {
		return vertexList.length;
	}

	public abstract int getPlaneNum();
	
	protected PolychoronVertex[] getEdge(int i) {
		PolychoronVertex[] e = { edges[i * 2], edges[i * 2 + 1] };
		return e;
	}
	protected PolychoronVertex[] getEdge(PolychoronVertex[] e,int i) {
		e[0]=edges[i * 2];
		e[1]=edges[i * 2 + 1];
		return e;
	}
	
	protected float[] getVetex() {
		return vertex;
	}

	private Comparator<PolychoronVertex> comp= new Comparator<PolychoronVertex>() {
			public int compare(PolychoronVertex o1, PolychoronVertex o2) {
				float[] n1 = o1.v3;
				float[] n2 = o2.v3;
				return n1[2] < n2[2] ? -1 : 1;
			}
	};
	void sort() {
		Arrays.sort(vertexList,comp);
	}

	PolychoronVertex getVetex(int i) {
		return vertexList[i];
	}
	
	void nextStep(){
		for (PolychoronVertex v : vertexList) {
			v.nextStep();
		}
	}
	void update() {
		for (PolychoronVertex v : vertexList) {
			v.convert1();
			v.convert2();
		}
	}
	private float scale=1;
	private float minScale=0.1f;
	private float maxScale=5;
	public void setScale(float s) {
		if(s<minScale){
			s=minScale;
		}else if(s>maxScale){
			s=maxScale;
		}
		scale=s;
		for (PolychoronVertex v : vertexList) {
			v.setScale(s);
		}
	}
	public float getScale() {
		return scale;
	}
	public void transposeM(float[] m1, float[] m2) {
		for (PolychoronVertex v : vertexList) {
			v.setConvert1(m1);
			v.setConvert2(m2);
		}
	}

	public void transpose3(float[] m2) {
		for (PolychoronVertex v : vertexList) {
			v.setConvert2(m2);
		}
	}

	public void transpose4(float[] m1) {
		for (PolychoronVertex v : vertexList) {
			v.setConvert1(m1);
		}
	}

	public void transpose4u(float[] m1) {
		for (PolychoronVertex v : vertexList) {
			v.setConvert1u(m1);
		}
	}

	public float[] cloneMatrix3d(int i) {
		float[] m = new float[16];
		Matrix.setIdentityM(m, 0);
		Matrix.translateM(m, 0, vertexList[i].v3[0], vertexList[i].v3[1],
				vertexList[i].v3[2]);
		return m;
	}
	public float[] copyMatrix3d(float[] m,int i) {
		Matrix.setIdentityM(m, 0);
		Matrix.translateM(m, 0, vertexList[i].v3[0], vertexList[i].v3[1],
				vertexList[i].v3[2]);
		return m;
	}

}
