package jp.ac.titech.sharp4k.cuten.sampletask;

import jp.ac.titech.sharp4k.cuten.BaseApp;
import jp.ac.titech.sharp4k.cuten.R;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.ScrollView;
import android.widget.TextView;

public class QATask extends BaseApp {
	private static final String TAG = QATask.class.getSimpleName();
	private Context ctx;
	private RadioGroup[] choices;
	private int num;
	private Resources res;

	@Override
	protected View createView(Context ctx, Resources res) {
		this.ctx = ctx;
		this.res = res;
		ScrollView root = new ScrollView(ctx);
		LinearLayout body = new LinearLayout(ctx);
		body.setOrientation(LinearLayout.VERTICAL);
		root.addView(body);

		TextView tv = new TextView(ctx);
		String message = res.getString(R.string.first);
		tv.setText(message);
		body.addView(tv);
		//
		String[] questions = res.getStringArray(R.array.questions);
		TypedArray typedArray = res.obtainTypedArray(R.array.choices);
		num = (questions.length < typedArray.length()) ? questions.length
				: typedArray.length();
		choices = new RadioGroup[num];
		RadioGroup.LayoutParams params = new RadioGroup.LayoutParams(0,
				RadioGroup.LayoutParams.FILL_PARENT, 1);
		for (int n = 0; n < num; n++) {
			TextView text = new TextView(ctx);
			text.setText(questions[n]);
			RadioGroup radioGroup = new RadioGroup(ctx);
			choices[n] = radioGroup;
			radioGroup.setOrientation(LinearLayout.HORIZONTAL);
			int id = typedArray.getResourceId(n, 0);
			String[] names = res.getStringArray(id);
			for (int i = 0; i < names.length; i++) {
				RadioButton btn = new RadioButton(ctx);
				btn.setText(names[i]);
				btn.setId(i);
				radioGroup.addView(btn, params);
			}
			body.addView(text);
			body.addView(radioGroup);
		}
		//

		return root;
	}

	@Override
	protected void onClose() {
		int[] choicesId = new int[num];
		for (int i = 0; i < num; i++) {
			choicesId[i] = choices[i].getCheckedRadioButtonId();
		}
		int[] answers = res.getIntArray(R.array.answers);
		num = (answers.length < num) ? answers.length : num;
		int correctCount = 0;
		for (int i = 0; i < num; i++) {
			if (answers[i] == choicesId[i]) {
				correctCount++;
			}
		}
		int res = correctCount * 100 / num;
		int[] result = { res };
		sendResult(result);
		super.onClose();
	}
}
