package jp.ac.titech.sharp4k.cuten;

import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;

public interface HttpStreamListener {
	// 通信に成功し 200 が返ってきたときに、非 UI スレッドで呼ばれる
	public void onSuccess(HttpEntity entity);

	// 通信には成功したがその他のステータスが返ってきたときに UI スレッドで呼ばれる
	public void onHttpFailure(StatusLine status);

	// 通信に失敗したときに UI スレッドで呼ばれる
	public void onFailure(Exception exception);

	// HTTP の結果に関係無く UI スレッドで最後に呼ばれる
	public void postExec();
}
