package jp.ac.titech.sharp4k.cuten;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;

import android.app.ProgressDialog;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup.MarginLayoutParams;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.inject.Inject;

public class LectureActivity extends BaseMenuActivity {
	private static final String TAG = "LectureActivity";
	private static final int TASK_REQUEST_CODE = 9;
	private List<Pair<Apk, Button>> buttons;
	private static final int BUTTON_MARGIN = 10;
	private ProgressDialog progressDialog;
	@Inject
	private HttpAPIClient apiClient;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.lecture);

		// データベース読み取りor作成
		SQLiteOpenHelper h = new SQLHelper(this);
		final SQLiteDatabase db = h.getReadableDatabase();
		// LECTURE_KEYを受け取って、データベースから講義情報を検索
		int lec = getIntent().getIntExtra(LectureFolderActivity.LECTURE_KEY, 1);
		Lecture lecture = Lecture.find(db, lec);

		// ヘッダ
		ImageView img = (ImageView) findViewById(R.id.imageButtonLecture);
		// アイコン
		// img.setImageResource(R.drawable.);
		// img.setOnClickListener();

		// スクロール
		LinearLayout scr = (LinearLayout) findViewById(R.id.linearViewLecture);
		// 上部に講義情報表示
		TextView tvLecture = (TextView) findViewById(R.id.lecture_info_name);
		tvLecture.setText(lecture.getName());
		TextView tvTeacher = (TextView) findViewById(R.id.lecture_info_teacher);
		tvTeacher.setText("(" + lecture.getTeacher().getName() + ")");

		buttons = new ArrayList<Pair<Apk, Button>>();
		// データベースからタスクを情報取得して、ボタンに表示
		{
			// 結果をlistに格納
			List<Task> tasks = lecture.findTasks(db);
			if (BuildConfig.DEBUG) {
				// Add debugging task
				tasks.add(new Task(-1, "DEBUG", lecture));
			}

			for (int i = 0; i < tasks.size(); i++) {
				final Task tsk = tasks.get(i);
				final Apk apk;
				if (BuildConfig.DEBUG && tsk.getId() < 0) {
					apk = new Apk(-1, 1, "DEBUG", tsk);
				} else {
					apk = tsk.findLatestApk(db);
				}

				// ボタン作成
				Button b = new Button(this);
				// 背景
				// b.setBackgroundDrawable(d);
				// 左にアイコン Drawable
				// d=getResources().getDrawable(R.drawable.nekonote);
				// d.setBounds(0, 0, d.getIntrinsicWidth()/2,
				// d.getIntrinsicHeight()/2); b.setCompoundDrawables(d,
				// null,null, null);

				b.setHeight(128);
				b.setTextSize(getResources().getDimensionPixelSize(
						R.dimen.task_name_text_size));
				b.setOnClickListener(new OnClickListener() {
					@Override
					public void onClick(View v) {
						if (!downloadApk(apk)) {
							// すでにファイルが存在する場合はすぐに起動
							launchApk(apk.getId());
						}
					}
				});
				scr.addView(b);
				b.setText(getTaskString(i, tsk));
				MarginLayoutParams lp = (MarginLayoutParams) b
						.getLayoutParams();
				lp.topMargin = BUTTON_MARGIN;
				buttons.add(new Pair<Apk, Button>(apk, b));
			}
			checkExistingAll();
		}
		db.close();

		progressDialog = new ProgressDialog(this);
		progressDialog.setMessage("ファイルをダウンロードしています");

		File iconCacheFile = lecture.getTeacher().getIconCacheFile(this);
		if (iconCacheFile != null && iconCacheFile.exists()) {
			img.setImageBitmap(BitmapFactory.decodeFile(iconCacheFile.getPath()));
		} else {
			apiClient.getIcon(lecture.getTeacher(), new GetIconListener(img,
					iconCacheFile));
		}
	}

	private String getTaskString(int no, Task task) {
		return no + ". " + task.getName();
	}

	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent intent) {
		super.onActivityResult(requestCode, resultCode, intent);
		switch (requestCode) {
		case TASK_REQUEST_CODE:
			onTaskFinish(resultCode, intent);
			break;
		default:
			Log.w(TAG, "Unknown requestCode: " + requestCode);
			break;
		}
	}

	private void onTaskFinish(int resultCode, Intent intent) {
		Log.d(TAG, "onTaskFinish: resultCode = " + resultCode);
		if (resultCode == RESULT_OK) {
			int result = intent.getIntExtra(TaskActivity.RESULT_KEY, -1);
			if (result < 0) {
				Toast.makeText(this, "閉じるボタンで戻って下さい＞＜", Toast.LENGTH_LONG)
						.show();
			}
		}
	}

	private final static int BUFFER_SIZE = 10240;

	private boolean downloadApk(final Apk apk) {
		if (BuildConfig.DEBUG && apk.getId() < 0) {
			// dummy apk for debugging
			return false;
		}
		final File file = apk.getSavedPath(this);
		if (file.exists()) {
			return false;
		}

		progressDialog.show();
		apiClient.downloadApk(apk, new HttpStreamListener() {
			@Override
			public void onSuccess(HttpEntity entity) {
				// Run in non-UI thread
				try {
					// ダウンロードしたファイルを保存
					InputStream inputstream = entity.getContent();
					BufferedInputStream bufferedinputstream = new BufferedInputStream(
							inputstream, BUFFER_SIZE);
					BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(
							new FileOutputStream(file, false), BUFFER_SIZE);
					byte buffer[] = new byte[BUFFER_SIZE];
					int size = 0;
					while (-1 != (size = bufferedinputstream.read(buffer))) {
						bufferedoutputstream.write(buffer, 0, size);
					}
					bufferedoutputstream.close();
					bufferedinputstream.close();
				} catch (final IOException e) {
					e.printStackTrace();
					new Handler(Looper.getMainLooper()).post(new Runnable() {
						@Override
						public void run() {
							Toast.makeText(LectureActivity.this,
									e.getMessage(), Toast.LENGTH_SHORT).show();
						}
					});
				}
			}

			@Override
			public void onFailure(Exception e) {
				e.printStackTrace();
				Toast.makeText(LectureActivity.this, e.getMessage(),
						Toast.LENGTH_SHORT).show();
			}

			@Override
			public void onHttpFailure(StatusLine status) {
				final int code = status.getStatusCode();
				final String msg;
				switch (code) {
				case HttpStatus.SC_NOT_FOUND:
					msg = "file not found";
					break;
				case HttpStatus.SC_REQUEST_TIMEOUT:
					msg = "request time out";
					break;
				default:
					msg = "http status: " + status.getStatusCode();
				}
				Toast.makeText(LectureActivity.this, msg, Toast.LENGTH_SHORT)
						.show();
			}

			@Override
			public void postExec() {
				progressDialog.dismiss();

				// ダウンロード終了時にapkを起動
				checkExistingAll();
				if (checkExisting(apk)) {
					launchApk(apk.getId());
				}
			}
		});
		return true;
	}

	private void launchApk(int apkId) {
		String apkName = apkId + ".apk";
		Intent intent = new Intent(this, TaskActivity.class);
		if (!BuildConfig.DEBUG || apkId >= 0) {
			// Don't send task's id when debugging apk is selected.
			intent.putExtra(TaskActivity.APK_ID_KEY, apkId);
		}
		Log.d(TAG, "startActivity: " + apkName);
		startActivityForResult(intent, TASK_REQUEST_CODE);
	}

	private boolean checkExisting(Apk apk) {
		if (BuildConfig.DEBUG && apk.getId() < 0) {
			// Debugging apk always exists
			return true;
		}
		return apk.getSavedPath(this).exists();
	}

	void checkExistingAll() {
		for (final Pair<Apk, Button> p : buttons) {
			final Apk apk = p.first;
			final Button b = p.second;
			if (checkExisting(apk)) {
				b.setBackgroundResource(R.drawable.lecture_normal_background);
			} else {
				b.setBackgroundResource(R.drawable.lecture_download_background);
			}
		}
	}

	private static class GetIconListener implements HttpStreamListener {
		private static final String TAG = GetIconListener.class.getSimpleName();

		private WeakReference<ImageView> viewRef;
		private Bitmap bitmap;
		private File cacheFile;

		public GetIconListener(ImageView view, File cacheFile) {
			this.viewRef = new WeakReference<ImageView>(view);
			this.bitmap = null;
			this.cacheFile = cacheFile;
		}

		public void onHttpFailure(StatusLine status) {
			Log.w(TAG, "HTTP failure: " + status.getStatusCode() + ": "
					+ status.getReasonPhrase());
		}

		public void onFailure(Exception e) {
			Log.w(TAG, "Caught exception: " + e.getMessage());
		}

		public void onSuccess(HttpEntity httpEntity) {
			// Run in non-UI thread
			try {
				FileOutputStream fos = new FileOutputStream(cacheFile);
				try {
					byte[] buf = EntityUtils.toByteArray(httpEntity);
					httpEntity.consumeContent();
					fos.write(buf, 0, buf.length);
					bitmap = BitmapFactory.decodeByteArray(buf, 0, buf.length);
				} catch (IOException e) {
					Log.e(TAG, "Caught IOException");
					e.printStackTrace();
				} finally {
					try {
						fos.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			} catch (FileNotFoundException e) {
				// should not be reached
				e.printStackTrace();
			}
		}

		public void postExec() {
			// Run in UI thread
			if (bitmap != null) {
				ImageView view = viewRef.get();
				if (view != null) {
					view.setImageBitmap(bitmap);
				} else {
					Log.d(TAG, "ImageView was GC-ed");
				}
			}
		}
	}
}
